/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class ConfigurableLineBorder
implements Border {
    private final boolean top;
    private final boolean left;
    private final boolean bottom;
    private final boolean right;
    private final int thickness;
    private final Insets insets;

    public ConfigurableLineBorder(boolean top, boolean left, boolean bottom, boolean right, int thickness) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
        this.thickness = thickness;
        this.insets = new Insets(top ? thickness : 0, left ? thickness : 0, bottom ? thickness : 0, right ? thickness : 0);
    }

    public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
        if (this.top) {
            graphics.fillRect(x, y, width, this.thickness);
        }
        if (this.bottom) {
            graphics.fillRect(x, y + height - this.thickness, width, this.thickness);
        }
        if (this.left) {
            graphics.fillRect(x, y, this.thickness, height);
        }
        if (this.right) {
            graphics.fillRect(x + width - this.thickness, y, this.thickness, height);
        }
    }

    public Insets getBorderInsets(Component component) {
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

