/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.watchmaker.swing.evolutionmonitor;

import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.uncommons.watchmaker.framework.PopulationData;
import org.uncommons.watchmaker.framework.islands.IslandEvolutionObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatusBar
extends Box
implements IslandEvolutionObserver<Object> {
    private final JLabel generationsLabel = new JLabel("N/A", 4);
    private final JLabel timeLabel = new JLabel("N/A", 4);
    private final JLabel populationLabel = new JLabel("N/A", 4);
    private final JLabel elitismLabel = new JLabel("N/A", 4);
    private final AtomicInteger islandPopulationSize = new AtomicInteger(-1);

    public StatusBar() {
        this(false);
    }

    public StatusBar(boolean islands) {
        super(0);
        this.add(new JLabel("Population: "));
        this.add(this.populationLabel);
        this.add(StatusBar.createHorizontalStrut(15));
        this.add(new JLabel("Elitism: "));
        this.add(this.elitismLabel);
        this.add(StatusBar.createHorizontalStrut(15));
        this.add(new JLabel(islands ? "Epochs: " : "Generations: "));
        this.add(this.generationsLabel);
        this.add(StatusBar.createHorizontalStrut(15));
        this.add(new JLabel("Elapsed Time: "));
        this.add(this.timeLabel);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.populationLabel.setName("Population");
        this.elitismLabel.setName("Elitism");
        this.generationsLabel.setName("Generations");
        this.timeLabel.setName("Time");
    }

    public void populationUpdate(final PopulationData<?> populationData) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (populationData.getGenerationNumber() == 0) {
                    int islandSize = StatusBar.this.islandPopulationSize.get();
                    if (islandSize > 0) {
                        int islandCount = populationData.getPopulationSize() / islandSize;
                        StatusBar.this.populationLabel.setText(islandCount + "x" + islandSize);
                        StatusBar.this.elitismLabel.setText(islandCount + "x" + populationData.getEliteCount());
                    } else {
                        StatusBar.this.populationLabel.setText(String.valueOf(populationData.getPopulationSize()));
                        StatusBar.this.elitismLabel.setText(String.valueOf(populationData.getEliteCount()));
                    }
                }
                StatusBar.this.generationsLabel.setText(String.valueOf(populationData.getGenerationNumber() + 1));
                StatusBar.this.timeLabel.setText(StatusBar.this.formatTime(populationData.getElapsedTime()));
            }
        });
    }

    public void islandPopulationUpdate(int islandIndex, final PopulationData<? extends Object> populationData) {
        this.islandPopulationSize.compareAndSet(-1, populationData.getPopulationSize());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusBar.this.timeLabel.setText(StatusBar.this.formatTime(populationData.getElapsedTime()));
            }
        });
    }

    private String formatTime(long time) {
        long seconds = time / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        long hours = minutes / 60L;
        minutes %= 60L;
        StringBuilder buffer = new StringBuilder();
        if (hours < 10L) {
            buffer.append('0');
        }
        buffer.append(hours);
        buffer.append(':');
        if (minutes < 10L) {
            buffer.append('0');
        }
        buffer.append(minutes);
        buffer.append(':');
        if (seconds < 10L) {
            buffer.append('0');
        }
        buffer.append(seconds);
        return buffer.toString();
    }
}

