/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.annotation;

import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.unidal.cat.annotation.CatAnnotationProcessor;
import org.unidal.cat.annotation.EnableCat;

class CatRegistrar
implements ImportBeanDefinitionRegistrar {
    CatRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableCat.class.getName());
        Object enabled = attributes.get("value");
        if (enabled instanceof Boolean) {
            if (((Boolean)enabled).booleanValue()) {
                this.registerIfNotExists(registry, CatAnnotationProcessor.class);
            } else {
                System.out.println("CAT is DISABLED explicitly by @EnabledCat(false). ");
            }
        }
    }

    private boolean registerIfNotExists(BeanDefinitionRegistry registry, Class<?> beanClass) {
        String[] candidates;
        String beanName = beanClass.getName();
        if (registry.containsBeanDefinition(beanName)) {
            return false;
        }
        for (String candidate : candidates = registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(candidate);
            if (!Objects.equals(beanDefinition.getBeanClassName(), beanClass.getName())) continue;
            return false;
        }
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition(beanClass).getBeanDefinition();
        registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        return true;
    }
}

