/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.autoconfigure;

import com.dianping.cat.Cat;
import java.io.File;
import org.apiguardian.api.API;
import org.unidal.cat.autoconfigure.CatProperties;

@API(status=API.Status.INTERNAL, since="1.0")
public class CatInitializer {
    private CatProperties m_properties;

    public CatInitializer(CatProperties properties) {
        this.m_properties = properties;
        boolean enabled = this.m_properties.isEnabled();
        if (enabled) {
            System.out.println("Trying to initialize CAT with " + this.m_properties);
            this.initialize();
        } else {
            System.out.println("CAT is DISABLED explicitly. use ${cat.enabled} to turn on.");
        }
    }

    private void initialize() {
        CatProperties.Server server = this.m_properties.getServer();
        String domain = this.m_properties.getDomain();
        int tcpPort = server.getTcpPort();
        int httpPort = server.getHttpPort();
        String userHome = System.getProperty("user.home");
        File catHome = new File(userHome, ".cat");
        catHome.mkdirs();
        System.setProperty("CAT_HOME", catHome.getAbsolutePath());
        Cat.getBootstrap().initializeByDomain(domain, tcpPort, httpPort, server.getAddresses());
    }
}

