/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.cat.autoconfigure;

import java.util.ArrayList;
import org.apiguardian.api.API;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="cat")
@API(status=API.Status.STABLE, since="1.0")
public class CatProperties {
    @API(status=API.Status.STABLE, since="1.0")
    private boolean m_enabled = true;
    @Value(value="${spring.application.name:Unknown}")
    @API(status=API.Status.STABLE, since="1.0")
    private String m_domain;
    @API(status=API.Status.STABLE, since="1.0")
    private Server m_server = new Server();

    public String getDomain() {
        return this.m_domain;
    }

    public Server getServer() {
        return this.m_server;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public void setServer(Server server) {
        this.m_server = server;
    }

    public String toString() {
        return String.format("Properties[enabled=%s, domain=%s, server=%s]", this.m_enabled, this.m_domain, this.m_server);
    }

    static class Server {
        private String m_ips;
        private int m_tcpPort = 2280;
        private int m_httpPort = 8080;

        Server() {
        }

        public String[] getAddresses() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.m_ips != null) {
                String[] parts;
                for (String part : parts = this.m_ips.split(",")) {
                    if (part.trim().length() <= 0) continue;
                    list.add(part.trim());
                }
            }
            return list.toArray(new String[0]);
        }

        public int getHttpPort() {
            return this.m_httpPort;
        }

        public String getIps() {
            return this.m_ips;
        }

        public int getTcpPort() {
            return this.m_tcpPort;
        }

        public void setHttpPort(int httpPort) {
            this.m_httpPort = httpPort;
        }

        public void setIps(String ips) {
            this.m_ips = ips;
        }

        public void setTcpPort(int tcpPort) {
            this.m_tcpPort = tcpPort;
        }

        public String toString() {
            return String.format("[ips: %s, tcp: %s, http: %s]", this.m_ips, this.m_tcpPort, this.m_httpPort);
        }
    }
}

