/* THIS FILE WAS AUTO GENERATED BY codegen-maven-plugin, DO NOT EDIT IT */
package org.unidal.codegen.model.transform;

import static org.unidal.codegen.model.Constants.ATTR_KEY;
import static org.unidal.codegen.model.Constants.ATTR_MODE;
import static org.unidal.codegen.model.Constants.ATTR_NAME;
import static org.unidal.codegen.model.Constants.ATTR_NO_NAMESPACE;
import static org.unidal.codegen.model.Constants.ATTR_OP;
import static org.unidal.codegen.model.Constants.ATTR_PATH;
import static org.unidal.codegen.model.Constants.ATTR_TEMPLATE;
import org.unidal.codegen.model.entity.Any;
import static org.unidal.codegen.model.Constants.ENTITY_CODEGEN;
import static org.unidal.codegen.model.Constants.ENTITY_FILE;
import static org.unidal.codegen.model.Constants.ENTITY_MANIFEST;
import static org.unidal.codegen.model.Constants.ENTITY_NODE;
import static org.unidal.codegen.model.Constants.ENTITY_OUTPUT;
import static org.unidal.codegen.model.Constants.ENTITY_OUTPUTS;
import static org.unidal.codegen.model.Constants.ENTITY_PROPERTY;
import static org.unidal.codegen.model.Constants.ENTITY_STRUCTURE;

import java.lang.reflect.Array;
import java.util.Collection;

import org.unidal.codegen.model.IEntity;
import org.unidal.codegen.model.IVisitor;
import org.unidal.codegen.model.entity.CodegenModel;
import org.unidal.codegen.model.entity.FileModel;
import org.unidal.codegen.model.entity.ManifestModel;
import org.unidal.codegen.model.entity.NodeModel;
import org.unidal.codegen.model.entity.OutputModel;
import org.unidal.codegen.model.entity.OutputsModel;
import org.unidal.codegen.model.entity.PropertyModel;
import org.unidal.codegen.model.entity.StructureModel;

public class DefaultXmlBuilder implements IVisitor {

   private IVisitor m_visitor = this;

   private int m_level;

   private StringBuilder m_sb;

   private boolean m_compact;

   public DefaultXmlBuilder() {
      this(false);
   }

   public DefaultXmlBuilder(boolean compact) {
      m_compact = compact;
   }

   public String build(IEntity<?> entity) {
      m_sb = new StringBuilder(8192);
      m_sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");

      entity.accept(m_visitor);
      return m_sb.toString();
   }

   protected void endTag(String name) {
      m_level--;

      indent();
      m_sb.append("</").append(name).append(">\r\n");
   }

   protected String escape(Object value) {
      return escape(value, false);
   }
   
   protected String escape(Object value, boolean text) {
      if (value == null) {
         return null;
      }

      String str = toString(value);
      int len = str.length();
      StringBuilder sb = new StringBuilder(len + 16);

      for (int i = 0; i < len; i++) {
         final char ch = str.charAt(i);

         switch (ch) {
         case '<':
            sb.append("&lt;");
            break;
         case '>':
            sb.append("&gt;");
            break;
         case '&':
            sb.append("&amp;");
            break;
         case '"':
            if (!text) {
               sb.append("&quot;");
               break;
            }
         default:
            sb.append(ch);
            break;
         }
      }

      return sb.toString();
   }
   
   protected void indent() {
      if (!m_compact) {
         for (int i = m_level - 1; i >= 0; i--) {
            m_sb.append("   ");
         }
      }
   }

   protected void startTag(String name) {
      startTag(name, false, null);
   }
   
   protected void startTag(String name, boolean closed, java.util.Map<String, String> dynamicAttributes, Object... nameValues) {
      startTag(name, null, closed, dynamicAttributes, nameValues);
   }

   protected void startTag(String name, java.util.Map<String, String> dynamicAttributes, Object... nameValues) {
      startTag(name, null, false, dynamicAttributes, nameValues);
   }

   protected void startTag(String name, Object text, boolean closed, java.util.Map<String, String> dynamicAttributes, Object... nameValues) {
      indent();

      m_sb.append('<').append(name);

      int len = nameValues.length;

      for (int i = 0; i + 1 < len; i += 2) {
         Object attrName = nameValues[i];
         Object attrValue = nameValues[i + 1];

         if (attrValue != null) {
            m_sb.append(' ').append(attrName).append("=\"").append(escape(attrValue)).append('"');
         }
      }

      if (dynamicAttributes != null) {
         for (java.util.Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
            m_sb.append(' ').append(e.getKey()).append("=\"").append(escape(e.getValue())).append('"');
         }
      }

      if (text != null && closed) {
         m_sb.append('>');
         m_sb.append(escape(text, true));
         m_sb.append("</").append(name).append(">\r\n");
      } else {
         if (closed) {
            m_sb.append('/');
         } else {
            m_level++;
         }
   
         m_sb.append(">\r\n");
      }
   }

   @SuppressWarnings("unchecked")
   protected String toString(Object value) {
      if (value instanceof String) {
         return (String) value;
      } else if (value instanceof Collection) {
         Collection<Object> list = (Collection<Object>) value;
         StringBuilder sb = new StringBuilder(32);
         boolean first = true;

         for (Object item : list) {
            if (first) {
               first = false;
            } else {
               sb.append(',');
            }

            if (item != null) {
               sb.append(item);
            }
         }

         return sb.toString();
      } else if (value.getClass().isArray()) {
         int len = Array.getLength(value);
         StringBuilder sb = new StringBuilder(32);
         boolean first = true;

         for (int i = 0; i < len; i++) {
            Object item = Array.get(value, i);

            if (first) {
               first = false;
            } else {
               sb.append(',');
            }

            if (item != null) {
               sb.append(item);
            }
         }
		
         return sb.toString();
      }
 
      return String.valueOf(value);
   }

   protected void tagWithText(String name, String text, java.util.Map<String, String> attributes) {
      if (text == null) {
         return;
      }
      
      indent();

      m_sb.append('<').append(name);

      if (attributes != null) {
         for (java.util.Map.Entry<String, String> e : attributes.entrySet()) {
            m_sb.append(' ').append(e.getKey()).append("=\"").append(escape(e.getValue())).append('"');
         }
      }

      m_sb.append(">");
      m_sb.append(escape(text, true));
      m_sb.append("</").append(name).append(">\r\n");
   }

   protected void tagWithText(String name, String text, Object... nameValues) {
      if (text == null) {
         return;
      }
      
      indent();

      m_sb.append('<').append(name);

      int len = nameValues.length;

      for (int i = 0; i + 1 < len; i += 2) {
         Object attrName = nameValues[i];
         Object attrValue = nameValues[i + 1];

         if (attrValue != null) {
            m_sb.append(' ').append(attrName).append("=\"").append(escape(attrValue)).append('"');
         }
      }

      m_sb.append(">");
      m_sb.append(escape(text, true));
      m_sb.append("</").append(name).append(">\r\n");
   }

   protected void element(String name, String text, String defaultValue, boolean escape) {
      if (text == null || text.equals(defaultValue)) {
         return;
      }
      
      indent();
      
      m_sb.append('<').append(name).append(">");
      
      if (escape) {
         m_sb.append(escape(text, true));
      } else {
         m_sb.append("<![CDATA[").append(text).append("]]>");
      }
      
      m_sb.append("</").append(name).append(">\r\n");
   }

   @Override
   public void visitAny(Any any) {
      if (any.getChildren().isEmpty()) {
         if (!any.getAttributes().isEmpty()) {
            if (any.hasValue() && any.getValue().length() != 0) {
               tagWithText(any.getName(), any.getValue(), any.getAttributes());
            } else {
               startTag(any.getName(), true, any.getAttributes());
            }
         } else if (any.hasValue()) {
            if (any.getName() == null) {
               if (any.getValue().trim().length() != 0) {
                  m_sb.append(any.getValue());
                }
            } else {
               tagWithText(any.getName(), any.getValue());
            }
         }
      } else {
         startTag(any.getName(), false, any.getAttributes());

         if (m_compact) {
            m_sb.setLength(m_sb.length() - 2);
         }

         for (Any child : any.getChildren()) {
            child.accept(m_visitor);
         }

         endTag(any.getName());

         if (m_compact) {
            m_sb.setLength(m_sb.length() - 2);
         }
      }
   }

   @Override
   public void visitCodegen(CodegenModel codegen) {
      startTag(ENTITY_CODEGEN, null);

      if (codegen.getManifest() != null) {
         codegen.getManifest().accept(m_visitor);
      }

      if (codegen.getStructure() != null) {
         codegen.getStructure().accept(m_visitor);
      }

      if (codegen.getOutputs() != null) {
         codegen.getOutputs().accept(m_visitor);
      }

      for (Any any : codegen.getData()) {
         any.accept(m_visitor);
      }

      endTag(ENTITY_CODEGEN);
   }

   @Override
   public void visitFile(FileModel file) {
      startTag(ENTITY_FILE, true, null, ATTR_PATH, file.getPath());
   }

   @Override
   public void visitManifest(ManifestModel manifest) {
      startTag(ENTITY_MANIFEST, null, ATTR_PATH, manifest.getPath());

      if (!manifest.getFiles().isEmpty()) {
         for (FileModel file : manifest.getFiles()) {
            file.accept(m_visitor);
         }
      }

      endTag(ENTITY_MANIFEST);
   }

   @Override
   public void visitNode(NodeModel node) {
      startTag(ENTITY_NODE, null, ATTR_NAME, node.getName(), ATTR_NO_NAMESPACE, node.getNoNamespace(), ATTR_KEY, node.getKey());

      if (!node.getNodes().isEmpty()) {
         for (NodeModel node_ : node.getNodes()) {
            node_.accept(m_visitor);
         }
      }

      endTag(ENTITY_NODE);
   }

   @Override
   public void visitOutput(OutputModel output) {
      startTag(ENTITY_OUTPUT, null, ATTR_PATH, output.getPath(), ATTR_OP, output.getOp(), ATTR_TEMPLATE, output.getTemplate(), ATTR_MODE, output.getMode());

      if (!output.getProperties().isEmpty()) {
         for (PropertyModel property : output.getProperties()) {
            property.accept(m_visitor);
         }
      }

      endTag(ENTITY_OUTPUT);
   }

   @Override
   public void visitOutputs(OutputsModel outputs) {
      startTag(ENTITY_OUTPUTS, null);

      if (!outputs.getOutputs().isEmpty()) {
         for (OutputModel output : outputs.getOutputs()) {
            output.accept(m_visitor);
         }
      }

      endTag(ENTITY_OUTPUTS);
   }

   @Override
   public void visitProperty(PropertyModel property) {
      startTag(ENTITY_PROPERTY, property.getText(), true, null, ATTR_NAME, property.getName());
   }

   @Override
   public void visitStructure(StructureModel structure) {
      startTag(ENTITY_STRUCTURE, null);

      if (structure.getNode() != null) {
         structure.getNode().accept(m_visitor);
      }

      endTag(ENTITY_STRUCTURE);
   }
}
