/* THIS FILE WAS AUTO GENERATED BY codegen-maven-plugin, DO NOT EDIT IT */
package org.unidal.codegen.model.transform;


import static org.unidal.codegen.model.Constants.ENTITY_CODEGEN;
import static org.unidal.codegen.model.Constants.ENTITY_FILE;
import static org.unidal.codegen.model.Constants.ENTITY_MANIFEST;
import static org.unidal.codegen.model.Constants.ENTITY_NODE;
import static org.unidal.codegen.model.Constants.ENTITY_OUTPUT;
import static org.unidal.codegen.model.Constants.ENTITY_OUTPUTS;
import static org.unidal.codegen.model.Constants.ENTITY_PROPERTY;
import static org.unidal.codegen.model.Constants.ENTITY_STRUCTURE;

import java.io.IOException;
import java.util.Map;
import java.util.Stack;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import org.unidal.codegen.model.IEntity;
import org.unidal.codegen.model.entity.Any;
import org.unidal.codegen.model.entity.CodegenModel;
import org.unidal.codegen.model.entity.FileModel;
import org.unidal.codegen.model.entity.ManifestModel;
import org.unidal.codegen.model.entity.NodeModel;
import org.unidal.codegen.model.entity.OutputModel;
import org.unidal.codegen.model.entity.OutputsModel;
import org.unidal.codegen.model.entity.PropertyModel;
import org.unidal.codegen.model.entity.StructureModel;

public class DefaultXmlParser extends DefaultHandler {

   private DefaultLinker m_linker = new DefaultLinker(true);

   private DefaultXmlMaker m_maker = new DefaultXmlMaker();

   private Stack<String> m_tags = new Stack<String>();

   private Stack<Object> m_objs = new Stack<Object>();

   private IEntity<?> m_root;

   private StringBuilder m_text = new StringBuilder(256);

   @SuppressWarnings("unchecked")
   public <T extends IEntity<?>> T parse(Class<T> entityType, InputSource input) throws IOException {
      try {
         SAXParserFactory factory = SAXParserFactory.newInstance();

         factory.setValidating(false);
         factory.setFeature("http://xml.org/sax/features/validation", false);
         factory.newSAXParser().parse(input, this);

         m_linker.finish();

         if (entityType.isAssignableFrom(m_root.getClass())) {
            return (T) m_root;
         } else {
            throw new IllegalArgumentException(String.format("Expected %s, but was %s", entityType, m_root.getClass()));
         }
      } catch (ParserConfigurationException e) {
         throw new IllegalStateException("Unable to get SAX Parser! " + e, e);
      } catch (SAXException e) {
         throw new IOException("Unable to parse XML! " + e, e);
      }
   }
   protected Any buildAny(String qName, Attributes attributes) {
      Any any = new Any();
      int length = attributes == null ? 0 : attributes.getLength();

      any.setName(qName);

      if (length > 0) {
         Map<String, String> dynamicAttributes = any.getAttributes();

         for (int i = 0; i < length; i++) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);

            dynamicAttributes.put(name, value);
         }
      }

      return any;
   }

   @SuppressWarnings("unchecked")
   protected <T> T convert(Class<T> type, String value, T defaultValue) {
      if (value == null || value.length() == 0) {
         return defaultValue;
      }

      if (type == Boolean.class) {
         return (T) Boolean.valueOf(value);
      } else if (type == Integer.class) {
         return (T) Integer.valueOf(value);
      } else if (type == Long.class) {
         return (T) Long.valueOf(value);
      } else if (type == Short.class) {
         return (T) Short.valueOf(value);
      } else if (type == Float.class) {
         return (T) Float.valueOf(value);
      } else if (type == Double.class) {
         return (T) Double.valueOf(value);
      } else if (type == Byte.class) {
         return (T) Byte.valueOf(value);
      } else if (type == Character.class) {
         return (T) (Character) value.charAt(0);
      } else {
         return (T) value;
      }
   }

   @Override
   public void characters(char[] ch, int start, int length) throws SAXException {
      m_text.append(ch, start, length);
   }

   @Override
   public void endElement(String uri, String localName, String qName) throws SAXException {
      if (uri == null || uri.length() == 0) {
         Object currentObj = m_objs.pop();

         m_tags.pop();

         if (currentObj instanceof PropertyModel) {
            PropertyModel property = (PropertyModel) currentObj;

            property.setText(getText());
         } else if (currentObj instanceof Any) {
            if (m_text.length() != 0) {
               ((Any) currentObj).setValue(getText());
            }
         } else if (currentObj instanceof CodegenModel) {
            if (m_text.length() != 0) {
               ((CodegenModel) currentObj).getData().add(new Any().setValue(getText()));
            }
         }
      }

      m_text.setLength(0);
   }

   protected String getText() {
      return m_text.toString();
   }

   private void parseForCodegen(CodegenModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      if (ENTITY_MANIFEST.equals(qName)) {
         ManifestModel manifest = m_maker.buildManifest(attributes);

         m_linker.onManifest(parentObj, manifest);
         m_objs.push(manifest);
      } else if (ENTITY_STRUCTURE.equals(qName)) {
         StructureModel structure = m_maker.buildStructure(attributes);

         m_linker.onStructure(parentObj, structure);
         m_objs.push(structure);
      } else if (ENTITY_OUTPUTS.equals(qName)) {
         OutputsModel outputs = m_maker.buildOutputs(attributes);

         m_linker.onOutputs(parentObj, outputs);
         m_objs.push(outputs);
      } else {
         String text = m_text.toString().trim();

         if (text.length() != 0) {
            Any any = new Any().setValue(text);

            parentObj.getData().add(any);
         }

         Any any = buildAny(qName, attributes);

         parentObj.getData().add(any);
         m_objs.push(any);
      }

      m_tags.push(qName);
   }

   private void parseForFile(FileModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      m_objs.push(parentObj);
      m_tags.push(qName);
   }

   private void parseForManifest(ManifestModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      if (ENTITY_FILE.equals(qName)) {
         FileModel file = m_maker.buildFile(attributes);

         m_linker.onFile(parentObj, file);
         m_objs.push(file);
      } else {
         throw new SAXException(String.format("Element(%s) is not expected under manifest!", qName));
      }

      m_tags.push(qName);
   }

   private void parseForNode(NodeModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      if (ENTITY_NODE.equals(qName)) {
         NodeModel node_ = m_maker.buildNode(attributes);

         m_linker.onNode(parentObj, node_);
         m_objs.push(node_);
      } else {
         throw new SAXException(String.format("Element(%s) is not expected under node!", qName));
      }

      m_tags.push(qName);
   }

   private void parseForOutput(OutputModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      if (ENTITY_PROPERTY.equals(qName)) {
         PropertyModel property = m_maker.buildProperty(attributes);

         m_linker.onProperty(parentObj, property);
         m_objs.push(property);
      } else {
         throw new SAXException(String.format("Element(%s) is not expected under output!", qName));
      }

      m_tags.push(qName);
   }

   private void parseForOutputs(OutputsModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      if (ENTITY_OUTPUT.equals(qName)) {
         OutputModel output = m_maker.buildOutput(attributes);

         m_linker.onOutput(parentObj, output);
         m_objs.push(output);
      } else {
         throw new SAXException(String.format("Element(%s) is not expected under outputs!", qName));
      }

      m_tags.push(qName);
   }

   private void parseForProperty(PropertyModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      m_objs.push(parentObj);
      m_tags.push(qName);
   }

   private void parseForStructure(StructureModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      if (ENTITY_NODE.equals(qName)) {
         NodeModel node_ = m_maker.buildNode(attributes);

         m_linker.onNode(parentObj, node_);
         m_objs.push(node_);
      } else {
         throw new SAXException(String.format("Element(%s) is not expected under structure!", qName));
      }

      m_tags.push(qName);
   }

   private void parseRoot(String qName, Attributes attributes) throws SAXException {
      if (ENTITY_CODEGEN.equals(qName)) {
         CodegenModel codegen = m_maker.buildCodegen(attributes);

         m_root = codegen;
         m_objs.push(codegen);
         m_tags.push(qName);
      } else if (ENTITY_MANIFEST.equals(qName)) {
         ManifestModel manifest = m_maker.buildManifest(attributes);

         m_root = manifest;
         m_objs.push(manifest);
         m_tags.push(qName);
      } else if (ENTITY_FILE.equals(qName)) {
         FileModel file = m_maker.buildFile(attributes);

         m_root = file;
         m_objs.push(file);
         m_tags.push(qName);
      } else if (ENTITY_STRUCTURE.equals(qName)) {
         StructureModel structure = m_maker.buildStructure(attributes);

         m_root = structure;
         m_objs.push(structure);
         m_tags.push(qName);
      } else if (ENTITY_NODE.equals(qName)) {
         NodeModel node = m_maker.buildNode(attributes);

         m_root = node;
         m_objs.push(node);
         m_tags.push(qName);
      } else if (ENTITY_OUTPUTS.equals(qName)) {
         OutputsModel outputs = m_maker.buildOutputs(attributes);

         m_root = outputs;
         m_objs.push(outputs);
         m_tags.push(qName);
      } else if (ENTITY_OUTPUT.equals(qName)) {
         OutputModel output = m_maker.buildOutput(attributes);

         m_root = output;
         m_objs.push(output);
         m_tags.push(qName);
      } else if (ENTITY_PROPERTY.equals(qName)) {
         PropertyModel property = m_maker.buildProperty(attributes);

         m_root = property;
         m_objs.push(property);
         m_tags.push(qName);
      } else {
         Any any = m_maker.buildAny(attributes);

         any.setName(qName);
         m_root = any;
         m_objs.push(any);
         m_tags.push(qName);
      }
   }

   @Override
   public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
      if (uri == null || uri.length() == 0) {
         if (m_objs.isEmpty()) { // root
            parseRoot(qName, attributes);
         } else {
            Object parent = m_objs.peek();
            String tag = m_tags.peek();

            if (parent instanceof Any) {
               Any any = buildAny(qName, attributes);

               ((Any) parent).addChild(any);
               m_objs.push(any);
               m_tags.push(qName);
            } else if (parent instanceof CodegenModel) {
               parseForCodegen((CodegenModel) parent, tag, qName, attributes);
            } else if (parent instanceof ManifestModel) {
               parseForManifest((ManifestModel) parent, tag, qName, attributes);
            } else if (parent instanceof FileModel) {
               parseForFile((FileModel) parent, tag, qName, attributes);
            } else if (parent instanceof StructureModel) {
               parseForStructure((StructureModel) parent, tag, qName, attributes);
            } else if (parent instanceof NodeModel) {
               parseForNode((NodeModel) parent, tag, qName, attributes);
            } else if (parent instanceof OutputsModel) {
               parseForOutputs((OutputsModel) parent, tag, qName, attributes);
            } else if (parent instanceof OutputModel) {
               parseForOutput((OutputModel) parent, tag, qName, attributes);
            } else if (parent instanceof PropertyModel) {
               parseForProperty((PropertyModel) parent, tag, qName, attributes);
            } else {
               throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
            }
         }

         m_text.setLength(0);
        } else {
         throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
      }
   }
}
