/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.framework;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.unidal.codegen.framework.XslTransformer;
import org.unidal.lookup.annotation.Named;

@Named(type=XslTransformer.class)
public class DefaultXslTransformer
implements XslTransformer {
    private Map<URL, Templates> m_cachedTemplates = new HashMap<URL, Templates>();
    private Map<URL, Long> m_lastModifiedDates = new HashMap<URL, Long>();

    private Templates getTemplates(URL style) {
        Templates templates = this.m_cachedTemplates.get(style);
        Long lastModifiedDate = this.m_lastModifiedDates.get(style);
        long lastModified = 0L;
        if ("file".equals(style.getProtocol())) {
            lastModified = new File(style.getFile()).lastModified();
        }
        if (templates == null || lastModifiedDate != lastModified) {
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setURIResolver(new URIResolver(){

                    @Override
                    public Source resolve(String href, String base) throws TransformerException {
                        try {
                            URL uri = new URL(new URL(base), href);
                            return new StreamSource(uri.openStream(), uri.toString());
                        }
                        catch (Exception e) {
                            System.err.println("Can't open XSL template (" + base + "," + href + ") " + e);
                            return null;
                        }
                    }
                });
                templates = factory.newTemplates(new StreamSource(style.openStream(), style.toString()));
                this.m_cachedTemplates.put(style, templates);
                this.m_lastModifiedDates.put(style, lastModified);
            }
            catch (Exception e) {
                throw new IllegalStateException("Fail to open XSL template: " + style, e);
            }
        }
        return templates;
    }

    private void setParameters(Transformer transformer, Map<String, String> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                transformer.setParameter(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public String transform(URL template, String source, Map<String, String> parameters) throws TransformerException {
        Transformer transformer = this.getTemplates(template).newTransformer();
        StringReader reader = new StringReader(source);
        StringWriter buffer = new StringWriter(65536);
        this.setParameters(transformer, parameters);
        transformer.transform(new StreamSource(reader), new StreamResult(buffer));
        return buffer.toString();
    }
}

