/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.framework;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.unidal.codegen.framework.GenerationContext;

public abstract class GenerationContextSupport
implements GenerationContext {
    private File m_projectBaseDir;
    private Map<String, String> m_properties;

    public GenerationContextSupport(File projectBaseDir) throws IOException {
        this.m_projectBaseDir = projectBaseDir.getCanonicalFile();
        this.m_properties = new HashMap<String, String>();
        this.m_properties.put("base-dir", this.m_projectBaseDir.getPath());
        this.m_properties.put("src-main-java", "src/main/java");
        this.m_properties.put("src-main-resources", "src/main/resources");
        this.m_properties.put("src-main-webapp", "src/main/webapp");
        this.m_properties.put("src-test-java", "src/test/java");
        this.m_properties.put("src-test-resources", "src/test/resources");
    }

    @Override
    public URL getDecorateXsl() {
        return this.getResource("decorate.xsl");
    }

    @Override
    public File getFile(String file) {
        if (file.startsWith("/")) {
            return new File(file);
        }
        return new File(this.m_projectBaseDir, file);
    }

    @Override
    public URL getManifestXsl() {
        return this.getResource("manifest.xsl");
    }

    @Override
    public URL getNormalizeXsl() {
        return this.getResource("normalize.xsl");
    }

    public File getPath(String name) {
        if (name.startsWith("/") || name.contains(":")) {
            return new File(name);
        }
        return new File(this.m_projectBaseDir, name);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.m_properties.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected abstract URL getResource(String var1);

    @Override
    public URL getStructureXml() {
        return this.getResource("../structure.xml");
    }

    @Override
    public URL getTemplateXsl(String relativeFile) {
        return this.getResource(relativeFile);
    }
}

