/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.framework.support;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.unidal.codegen.framework.XslGenerator;
import org.unidal.helper.Files;
import org.unidal.helper.Reflects;
import org.unidal.helper.Scanners;
import org.unidal.lookup.ComponentTestCase;
import org.unidal.lookup.PlexusContainer;

public class CodegenMojoSupport
extends ComponentTestCase {
    protected static void setField(Object instance, String fieldName, Object value) throws Exception {
        Field field = Reflects.forField().getDeclaredField(instance, fieldName);
        field.setAccessible(true);
        field.set(instance, value);
    }

    protected <T extends Mojo> MyMojoBuilder<T> builderOf(Class<T> mojoClass, MyHelper helper) throws Exception {
        MyMojoBuilder builder = new MyMojoBuilder();
        builder.initialize(this.getContainer(), mojoClass, helper);
        return builder;
    }

    protected void compileSources(MyHelper helper) throws Exception {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager manager = compiler.getStandardFileManager(diagnostics, null, null);
        manager.setLocation(StandardLocation.SOURCE_PATH, helper.getSourcesPath());
        manager.setLocation(StandardLocation.CLASS_OUTPUT, helper.getClassOutput());
        Files.forDir().delete(helper.getClassOutput().get(0), true);
        boolean success = compiler.getTask(null, manager, diagnostics, null, null, helper.sourceFiles()).call();
        manager.close();
        if (!success) {
            for (Diagnostic d : diagnostics.getDiagnostics()) {
                helper.addMessage(d);
            }
        }
    }

    protected void copyResources(MyHelper helper) throws IOException {
        File resourcesPath = helper.getTestResourcesPath();
        if (resourcesPath.isDirectory()) {
            File classOutput = helper.getClassOutput().get(0);
            Files.forDir().copyDir(resourcesPath, classOutput);
        }
    }

    protected void generateSources(MyHelper helper) throws Exception {
        File baseDir = helper.getBaseDir();
        Mojo mojo = this.builderOf(helper.getMojoClass(), helper).component("m_generator", XslGenerator.class, null).build();
        final AtomicReference manifest = new AtomicReference();
        Scanners.forDir().scan(new File(baseDir, "model"), (Scanners.IMatcher)new Scanners.FileMatcher(){

            public Scanners.IMatcher.Direction matches(File base, String path) {
                if (path.equals("manifest.xml") || path.endsWith("-manifest.xml")) {
                    manifest.set(new File(base, path));
                }
                return Scanners.IMatcher.Direction.NEXT;
            }
        });
        CodegenMojoSupport.setField(mojo, "sourceDir", helper.getGeneratedSourcesPath().toString());
        CodegenMojoSupport.setField(mojo, "manifest", ((File)manifest.get()).getPath());
        mojo.execute();
    }

    public static class MyMojoBuilder<T extends Mojo> {
        private PlexusContainer m_container;
        private T m_mojo;

        private MyMojoBuilder() {
        }

        public T build() throws Exception {
            return this.m_mojo;
        }

        public MyMojoBuilder<T> component(String fieldName, Class<?> role, String roleHint) throws Exception {
            Object component = this.m_container.lookup(role, roleHint);
            CodegenMojoSupport.setField(this.m_mojo, fieldName, component);
            if (component instanceof LogEnabled) {
                ((LogEnabled)component).enableLogging((Logger)new ConsoleLogger());
            }
            if (component instanceof Initializable) {
                ((Initializable)component).initialize();
            }
            return this;
        }

        private void initialize(PlexusContainer container, Class<T> mojoClass, MyHelper helper) throws Exception {
            this.m_container = container;
            this.m_mojo = (Mojo)mojoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.m_mojo.setLog(helper.getLog());
            MavenProject project = new MavenProject(){

                public File getBasedir() {
                    return new File(".").getAbsoluteFile();
                }
            };
            CodegenMojoSupport.setField(this.m_mojo, "m_project", project);
        }
    }

    private static class MyMessage {
        private String m_message;
        private Throwable m_cause;
        private boolean m_error;

        public MyMessage(MyHelper helper, Diagnostic<? extends JavaFileObject> diagnostic) {
            StringBuilder sb = new StringBuilder(256);
            sb.append('[').append(helper.getScenario()).append("] [").append((Object)diagnostic.getKind()).append("] ");
            if (diagnostic.getSource() != null) {
                sb.append(diagnostic.getSource().getName()).append(' ');
                sb.append(diagnostic.getLineNumber()).append(':').append(diagnostic.getColumnNumber()).append(' ');
            }
            sb.append(diagnostic.getMessage(Locale.US));
            this.m_message = sb.toString();
            this.m_error = diagnostic.getKind().name().equals("ERROR");
        }

        public Throwable getCause() {
            return this.m_cause;
        }

        public boolean isSuccess() {
            return !this.m_error;
        }

        public String toString() {
            return this.m_message;
        }
    }

    private static class MyLog
    extends SystemStreamLog {
        private String m_scenario;

        public MyLog(String scenario) {
            this.m_scenario = scenario;
        }

        public void info(CharSequence content) {
            System.out.println("[" + this.m_scenario + "] [INFO] " + content.toString());
        }
    }

    protected static class MyHelper {
        private String m_type;
        private String m_scenario;
        private File m_baseDir;
        private List<MyMessage> m_messages = new ArrayList<MyMessage>();
        private Log m_log;
        private Class<? extends Mojo> m_mojoClass;

        public MyHelper(Class<? extends Mojo> mojoClass, String type, String scenario) {
            this.m_mojoClass = mojoClass;
            this.m_type = type;
            this.m_scenario = scenario;
            this.m_baseDir = new File(String.format("src/test/%s/%s", type, scenario));
            this.m_log = new MyLog(scenario);
            if (!this.m_baseDir.exists()) {
                throw new IllegalArgumentException(String.format("Scenario(%s) of mojo(%s) does not found!", scenario, type));
            }
            Files.forDir().delete(new File(this.m_baseDir, "target"), true);
        }

        public void addMessage(Diagnostic<? extends JavaFileObject> diagnostic) {
            this.m_messages.add(new MyMessage(this, diagnostic));
        }

        public Exception buildError() {
            StringBuilder sb = new StringBuilder(256);
            int count = 0;
            Throwable cause = null;
            for (MyMessage message : this.m_messages) {
                if (message.isSuccess()) continue;
                sb.append(message).append("\r\n");
                ++count;
                if (cause != null || message.getCause() == null) continue;
                cause = message.getCause();
            }
            sb.insert(0, String.format("Generated code failed to compile, %s errors found:\r\n", count));
            return new RuntimeException(sb.substring(0, sb.length() - 2), cause);
        }

        public boolean checkError() {
            boolean found = false;
            for (MyMessage message : this.m_messages) {
                System.out.println(message);
                if (message.isSuccess()) continue;
                found = true;
            }
            return !found;
        }

        public File getBaseDir() {
            return this.m_baseDir;
        }

        public List<File> getClassOutput() {
            return this.pathOf(true, "target/classes");
        }

        public File getGeneratedSourcesPath() {
            return new File(this.m_baseDir, "target/generated-sources");
        }

        public Log getLog() {
            return this.m_log;
        }

        public Class<? extends Mojo> getMojoClass() {
            return this.m_mojoClass;
        }

        public String getScenario() {
            return this.m_scenario;
        }

        public List<File> getSourcesPath() {
            return this.pathOf(false, "sources", "target/generated-sources", "test-sources", "../sources");
        }

        public File getTestResourcesPath() {
            return new File(this.m_baseDir, "test-resources");
        }

        public String getType() {
            return this.m_type;
        }

        private List<File> pathOf(boolean createIfNotExists, String ... files) {
            ArrayList<File> lists = new ArrayList<File>();
            for (String file : files) {
                File path = new File(this.m_baseDir, file);
                if (path.exists()) {
                    lists.add(path);
                    continue;
                }
                if (!createIfNotExists) continue;
                if (path.mkdirs()) {
                    lists.add(path);
                    continue;
                }
                System.out.println(String.format("Unable to create directory(%s).", path));
            }
            return lists;
        }

        public List<JavaFileObject> sourceFiles() {
            final ArrayList<JavaFileObject> files = new ArrayList<JavaFileObject>();
            for (File path : this.getSourcesPath()) {
                Scanners.forDir().scan(path, (Scanners.IMatcher)new Scanners.FileMatcher(){

                    public Scanners.IMatcher.Direction matches(File base, String path) {
                        if (path.endsWith(".java")) {
                            try {
                                final String content = Files.forIO().readFrom(new File(base, path), "utf-8");
                                files.add(new SimpleJavaFileObject(new File(base, path).toURI(), JavaFileObject.Kind.SOURCE){

                                    @Override
                                    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                                        return content;
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        return Scanners.IMatcher.Direction.DOWN;
                    }
                });
            }
            return files;
        }
    }
}

