/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.model;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.unidal.codegen.model.IEntity;
import org.unidal.codegen.model.entity.CodegenModel;
import org.unidal.codegen.model.transform.DefaultXmlBuilder;
import org.unidal.codegen.model.transform.DefaultXmlParser;
import org.xml.sax.InputSource;

public class CodegenModelHelper {
    public static String asXml(IEntity<?> entity) {
        return new DefaultXmlBuilder().build(entity);
    }

    public static <T extends IEntity<T>> T fromXml(Class<T> entityType, InputStream in) throws IOException {
        return new DefaultXmlParser().parse(entityType, new InputSource(CodegenModelHelper.withoutBom(in)));
    }

    public static <T extends IEntity<T>> T fromXml(Class<T> entityType, String xml) throws IOException {
        return new DefaultXmlParser().parse(entityType, new InputSource(new StringReader(xml)));
    }

    public static CodegenModel fromXml(InputStream in) throws IOException {
        return CodegenModelHelper.fromXml(CodegenModel.class, in);
    }

    public static CodegenModel fromXml(String xml) throws IOException {
        return CodegenModelHelper.fromXml(CodegenModel.class, xml);
    }

    private static InputStream withoutBom(InputStream in) throws IOException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        in.mark(3);
        if (in.read() != 239 || in.read() != 187 || in.read() != 191) {
            in.reset();
        }
        return in;
    }
}

