/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.model.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.codegen.model.BaseEntity;
import org.unidal.codegen.model.IVisitor;

public class NodeModel
extends BaseEntity<NodeModel> {
    private String m_name;
    private Boolean m_noNamespace;
    private String m_key;
    private List<NodeModel> m_nodes = new ArrayList<NodeModel>();

    public NodeModel() {
    }

    public NodeModel(String name) {
        this.m_name = name;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitNode(this);
    }

    public NodeModel addNode(NodeModel node) {
        this.m_nodes.add(node);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeModel) {
            NodeModel _o = (NodeModel)obj;
            return this.equals(this.getName(), _o.getName());
        }
        return false;
    }

    public NodeModel findNode(String name) {
        for (NodeModel node : this.m_nodes) {
            if (!this.equals(node.getName(), name)) continue;
            return node;
        }
        return null;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getName() {
        return this.m_name;
    }

    public List<NodeModel> getNodes() {
        return this.m_nodes;
    }

    public Boolean getNoNamespace() {
        return this.m_noNamespace;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_name == null ? 0 : this.m_name.hashCode());
        return hash;
    }

    public boolean isNoNamespace() {
        return this.m_noNamespace != null && this.m_noNamespace != false;
    }

    @Override
    public void mergeAttributes(NodeModel other) {
        this.assertAttributeEquals(other, "node", "name", this.m_name, other.getName());
        if (other.getNoNamespace() != null) {
            this.m_noNamespace = other.getNoNamespace();
        }
        if (other.getKey() != null) {
            this.m_key = other.getKey();
        }
    }

    public NodeModel removeNode(String name) {
        int len = this.m_nodes.size();
        for (int i = 0; i < len; ++i) {
            NodeModel node = this.m_nodes.get(i);
            if (!this.equals(node.getName(), name)) continue;
            return this.m_nodes.remove(i);
        }
        return null;
    }

    public NodeModel setKey(String key) {
        this.m_key = key;
        return this;
    }

    public NodeModel setName(String name) {
        this.m_name = name;
        return this;
    }

    public NodeModel setNoNamespace(Boolean noNamespace) {
        this.m_noNamespace = noNamespace;
        return this;
    }
}

