/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.model.entity;

import java.util.ArrayList;
import java.util.List;
import org.unidal.codegen.model.BaseEntity;
import org.unidal.codegen.model.IVisitor;
import org.unidal.codegen.model.entity.PropertyModel;

public class OutputModel
extends BaseEntity<OutputModel> {
    private String m_path;
    private String m_op;
    private String m_template;
    private String m_mode;
    private List<PropertyModel> m_properties = new ArrayList<PropertyModel>();

    public OutputModel() {
    }

    public OutputModel(String path) {
        this.m_path = path;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitOutput(this);
    }

    public OutputModel addProperty(PropertyModel property) {
        this.m_properties.add(property);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OutputModel) {
            OutputModel _o = (OutputModel)obj;
            return this.equals(this.getPath(), _o.getPath());
        }
        return false;
    }

    public PropertyModel findProperty(String name) {
        for (PropertyModel property : this.m_properties) {
            if (!this.equals(property.getName(), name)) continue;
            return property;
        }
        return null;
    }

    public String getMode() {
        return this.m_mode;
    }

    public String getOp() {
        return this.m_op;
    }

    public String getPath() {
        return this.m_path;
    }

    public List<PropertyModel> getProperties() {
        return this.m_properties;
    }

    public String getTemplate() {
        return this.m_template;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_path == null ? 0 : this.m_path.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(OutputModel other) {
        this.assertAttributeEquals(other, "output", "path", this.m_path, other.getPath());
        if (other.getOp() != null) {
            this.m_op = other.getOp();
        }
        if (other.getTemplate() != null) {
            this.m_template = other.getTemplate();
        }
        if (other.getMode() != null) {
            this.m_mode = other.getMode();
        }
    }

    public PropertyModel removeProperty(String name) {
        int len = this.m_properties.size();
        for (int i = 0; i < len; ++i) {
            PropertyModel property = this.m_properties.get(i);
            if (!this.equals(property.getName(), name)) continue;
            return this.m_properties.remove(i);
        }
        return null;
    }

    public OutputModel setMode(String mode) {
        this.m_mode = mode;
        return this;
    }

    public OutputModel setOp(String op) {
        this.m_op = op;
        return this;
    }

    public OutputModel setPath(String path) {
        this.m_path = path;
        return this;
    }

    public OutputModel setTemplate(String template) {
        this.m_template = template;
        return this;
    }
}

