/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.model.transform;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.unidal.codegen.model.IEntity;
import org.unidal.codegen.model.IVisitor;
import org.unidal.codegen.model.entity.Any;
import org.unidal.codegen.model.entity.CodegenModel;
import org.unidal.codegen.model.entity.FileModel;
import org.unidal.codegen.model.entity.ManifestModel;
import org.unidal.codegen.model.entity.NodeModel;
import org.unidal.codegen.model.entity.OutputModel;
import org.unidal.codegen.model.entity.OutputsModel;
import org.unidal.codegen.model.entity.PropertyModel;
import org.unidal.codegen.model.entity.StructureModel;

public class DefaultXmlBuilder
implements IVisitor {
    private IVisitor m_visitor = this;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultXmlBuilder() {
        this(false);
    }

    public DefaultXmlBuilder(boolean compact) {
        this.m_compact = compact;
    }

    public String build(IEntity<?> entity) {
        this.m_sb = new StringBuilder(8192);
        this.m_sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        entity.accept(this.m_visitor);
        return this.m_sb.toString();
    }

    protected void endTag(String name) {
        --this.m_level;
        this.indent();
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected String escape(Object value) {
        return this.escape(value, false);
    }

    protected String escape(Object value, boolean text) {
        if (value == null) {
            return null;
        }
        String str = this.toString(value);
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 16);
        block6: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (!text) {
                        sb.append("&quot;");
                        continue block6;
                    }
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void startTag(String name) {
        this.startTag(name, false, null, new Object[0]);
    }

    protected void startTag(String name, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, (Object)null, closed, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, (Object)null, false, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Object text, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                this.m_sb.append(' ').append(e.getKey()).append("=\"").append(this.escape(e.getValue())).append('\"');
            }
        }
        if (text != null && closed) {
            this.m_sb.append('>');
            this.m_sb.append(this.escape(text, true));
            this.m_sb.append("</").append(name).append(">\r\n");
        } else {
            if (closed) {
                this.m_sb.append('/');
            } else {
                ++this.m_level;
            }
            this.m_sb.append(">\r\n");
        }
    }

    protected String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            StringBuilder sb = new StringBuilder(32);
            boolean first = true;
            for (Object item : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (item == null) continue;
                sb.append(item);
            }
            return sb.toString();
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            StringBuilder sb = new StringBuilder(32);
            boolean first = true;
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(value, i);
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (item == null) continue;
                sb.append(item);
            }
            return sb.toString();
        }
        return String.valueOf(value);
    }

    protected void tagWithText(String name, String text, Map<String, String> attributes) {
        if (text == null) {
            return;
        }
        this.indent();
        this.m_sb.append('<').append(name);
        if (attributes != null) {
            for (Map.Entry<String, String> e : attributes.entrySet()) {
                this.m_sb.append(' ').append(e.getKey()).append("=\"").append(this.escape(e.getValue())).append('\"');
            }
        }
        this.m_sb.append(">");
        this.m_sb.append(this.escape(text, true));
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected void tagWithText(String name, String text, Object ... nameValues) {
        if (text == null) {
            return;
        }
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        this.m_sb.append(">");
        this.m_sb.append(this.escape(text, true));
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected void element(String name, String text, String defaultValue, boolean escape) {
        if (text == null || text.equals(defaultValue)) {
            return;
        }
        this.indent();
        this.m_sb.append('<').append(name).append(">");
        if (escape) {
            this.m_sb.append(this.escape(text, true));
        } else {
            this.m_sb.append("<![CDATA[").append(text).append("]]>");
        }
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    @Override
    public void visitAny(Any any) {
        if (any.getChildren().isEmpty()) {
            if (!any.getAttributes().isEmpty()) {
                if (any.hasValue() && any.getValue().length() != 0) {
                    this.tagWithText(any.getName(), any.getValue(), any.getAttributes());
                } else {
                    this.startTag(any.getName(), true, any.getAttributes(), new Object[0]);
                }
            } else if (any.hasValue()) {
                if (any.getName() == null) {
                    if (any.getValue().trim().length() != 0) {
                        this.m_sb.append(any.getValue());
                    }
                } else {
                    this.tagWithText(any.getName(), any.getValue(), new Object[0]);
                }
            }
        } else {
            this.startTag(any.getName(), false, any.getAttributes(), new Object[0]);
            if (this.m_compact) {
                this.m_sb.setLength(this.m_sb.length() - 2);
            }
            for (Any child : any.getChildren()) {
                child.accept(this.m_visitor);
            }
            this.endTag(any.getName());
            if (this.m_compact) {
                this.m_sb.setLength(this.m_sb.length() - 2);
            }
        }
    }

    @Override
    public void visitCodegen(CodegenModel codegen) {
        this.startTag("codegen", null, new Object[0]);
        if (codegen.getManifest() != null) {
            codegen.getManifest().accept(this.m_visitor);
        }
        if (codegen.getStructure() != null) {
            codegen.getStructure().accept(this.m_visitor);
        }
        if (codegen.getOutputs() != null) {
            codegen.getOutputs().accept(this.m_visitor);
        }
        for (Any any : codegen.getData()) {
            any.accept(this.m_visitor);
        }
        this.endTag("codegen");
    }

    @Override
    public void visitFile(FileModel file) {
        this.startTag("file", true, null, "path", file.getPath());
    }

    @Override
    public void visitManifest(ManifestModel manifest) {
        this.startTag("manifest", null, "path", manifest.getPath());
        if (!manifest.getFiles().isEmpty()) {
            for (FileModel file : manifest.getFiles()) {
                file.accept(this.m_visitor);
            }
        }
        this.endTag("manifest");
    }

    @Override
    public void visitNode(NodeModel node) {
        this.startTag("node", null, "name", node.getName(), "no-namespace", node.getNoNamespace(), "key", node.getKey());
        if (!node.getNodes().isEmpty()) {
            for (NodeModel node_ : node.getNodes()) {
                node_.accept(this.m_visitor);
            }
        }
        this.endTag("node");
    }

    @Override
    public void visitOutput(OutputModel output) {
        this.startTag("output", null, "path", output.getPath(), "op", output.getOp(), "template", output.getTemplate(), "mode", output.getMode());
        if (!output.getProperties().isEmpty()) {
            for (PropertyModel property : output.getProperties()) {
                property.accept(this.m_visitor);
            }
        }
        this.endTag("output");
    }

    @Override
    public void visitOutputs(OutputsModel outputs) {
        this.startTag("outputs", null, new Object[0]);
        if (!outputs.getOutputs().isEmpty()) {
            for (OutputModel output : outputs.getOutputs()) {
                output.accept(this.m_visitor);
            }
        }
        this.endTag("outputs");
    }

    @Override
    public void visitProperty(PropertyModel property) {
        this.startTag("property", property.getText(), true, null, "name", property.getName());
    }

    @Override
    public void visitStructure(StructureModel structure) {
        this.startTag("structure", null, new Object[0]);
        if (structure.getNode() != null) {
            structure.getNode().accept(this.m_visitor);
        }
        this.endTag("structure");
    }
}

