/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.model.transform;

import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.unidal.codegen.model.IEntity;
import org.unidal.codegen.model.entity.Any;
import org.unidal.codegen.model.entity.CodegenModel;
import org.unidal.codegen.model.entity.FileModel;
import org.unidal.codegen.model.entity.ManifestModel;
import org.unidal.codegen.model.entity.NodeModel;
import org.unidal.codegen.model.entity.OutputModel;
import org.unidal.codegen.model.entity.OutputsModel;
import org.unidal.codegen.model.entity.PropertyModel;
import org.unidal.codegen.model.entity.StructureModel;
import org.unidal.codegen.model.transform.DefaultLinker;
import org.unidal.codegen.model.transform.DefaultXmlMaker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultXmlParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultXmlMaker m_maker = new DefaultXmlMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_root;
    private StringBuilder m_text = new StringBuilder(256);

    public <T extends IEntity<?>> T parse(Class<T> entityType, InputSource input) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(input, (DefaultHandler)this);
            this.m_linker.finish();
            if (entityType.isAssignableFrom(this.m_root.getClass())) {
                return (T)this.m_root;
            }
            throw new IllegalArgumentException(String.format("Expected %s, but was %s", entityType, this.m_root.getClass()));
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX Parser! " + e, e);
        }
        catch (SAXException e) {
            throw new IOException("Unable to parse XML! " + e, e);
        }
    }

    protected Any buildAny(String qName, Attributes attributes) {
        Any any = new Any();
        int length = attributes == null ? 0 : attributes.getLength();
        any.setName(qName);
        if (length > 0) {
            Map<String, String> dynamicAttributes = any.getAttributes();
            for (int i = 0; i < length; ++i) {
                String name = attributes.getQName(i);
                String value = attributes.getValue(i);
                dynamicAttributes.put(name, value);
            }
        }
        return any;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.m_objs.pop();
            this.m_tags.pop();
            if (currentObj instanceof PropertyModel) {
                PropertyModel property = (PropertyModel)currentObj;
                property.setText(this.getText());
            } else if (currentObj instanceof Any) {
                if (this.m_text.length() != 0) {
                    ((Any)currentObj).setValue(this.getText());
                }
            } else if (currentObj instanceof CodegenModel && this.m_text.length() != 0) {
                ((CodegenModel)currentObj).getData().add(new Any().setValue(this.getText()));
            }
        }
        this.m_text.setLength(0);
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForCodegen(CodegenModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("manifest".equals(qName)) {
            ManifestModel manifest = this.m_maker.buildManifest(attributes);
            this.m_linker.onManifest(parentObj, manifest);
            this.m_objs.push(manifest);
        } else if ("structure".equals(qName)) {
            StructureModel structure = this.m_maker.buildStructure(attributes);
            this.m_linker.onStructure(parentObj, structure);
            this.m_objs.push(structure);
        } else if ("outputs".equals(qName)) {
            OutputsModel outputs = this.m_maker.buildOutputs(attributes);
            this.m_linker.onOutputs(parentObj, outputs);
            this.m_objs.push(outputs);
        } else {
            Any any;
            String text = this.m_text.toString().trim();
            if (text.length() != 0) {
                any = new Any().setValue(text);
                parentObj.getData().add(any);
            }
            any = this.buildAny(qName, attributes);
            parentObj.getData().add(any);
            this.m_objs.push(any);
        }
        this.m_tags.push(qName);
    }

    private void parseForFile(FileModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForManifest(ManifestModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"file".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under manifest!", qName));
        }
        FileModel file = this.m_maker.buildFile(attributes);
        this.m_linker.onFile(parentObj, file);
        this.m_objs.push(file);
        this.m_tags.push(qName);
    }

    private void parseForNode(NodeModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"node".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under node!", qName));
        }
        NodeModel node_ = this.m_maker.buildNode(attributes);
        this.m_linker.onNode(parentObj, node_);
        this.m_objs.push(node_);
        this.m_tags.push(qName);
    }

    private void parseForOutput(OutputModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"property".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under output!", qName));
        }
        PropertyModel property = this.m_maker.buildProperty(attributes);
        this.m_linker.onProperty(parentObj, property);
        this.m_objs.push(property);
        this.m_tags.push(qName);
    }

    private void parseForOutputs(OutputsModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"output".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under outputs!", qName));
        }
        OutputModel output = this.m_maker.buildOutput(attributes);
        this.m_linker.onOutput(parentObj, output);
        this.m_objs.push(output);
        this.m_tags.push(qName);
    }

    private void parseForProperty(PropertyModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseForStructure(StructureModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"node".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under structure!", qName));
        }
        NodeModel node_ = this.m_maker.buildNode(attributes);
        this.m_linker.onNode(parentObj, node_);
        this.m_objs.push(node_);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("codegen".equals(qName)) {
            CodegenModel codegen;
            this.m_root = codegen = this.m_maker.buildCodegen(attributes);
            this.m_objs.push(codegen);
            this.m_tags.push(qName);
        } else if ("manifest".equals(qName)) {
            ManifestModel manifest;
            this.m_root = manifest = this.m_maker.buildManifest(attributes);
            this.m_objs.push(manifest);
            this.m_tags.push(qName);
        } else if ("file".equals(qName)) {
            FileModel file;
            this.m_root = file = this.m_maker.buildFile(attributes);
            this.m_objs.push(file);
            this.m_tags.push(qName);
        } else if ("structure".equals(qName)) {
            StructureModel structure;
            this.m_root = structure = this.m_maker.buildStructure(attributes);
            this.m_objs.push(structure);
            this.m_tags.push(qName);
        } else if ("node".equals(qName)) {
            NodeModel node;
            this.m_root = node = this.m_maker.buildNode(attributes);
            this.m_objs.push(node);
            this.m_tags.push(qName);
        } else if ("outputs".equals(qName)) {
            OutputsModel outputs;
            this.m_root = outputs = this.m_maker.buildOutputs(attributes);
            this.m_objs.push(outputs);
            this.m_tags.push(qName);
        } else if ("output".equals(qName)) {
            OutputModel output;
            this.m_root = output = this.m_maker.buildOutput(attributes);
            this.m_objs.push(output);
            this.m_tags.push(qName);
        } else if ("property".equals(qName)) {
            PropertyModel property;
            this.m_root = property = this.m_maker.buildProperty(attributes);
            this.m_objs.push(property);
            this.m_tags.push(qName);
        } else {
            Any any = this.m_maker.buildAny(attributes);
            any.setName(qName);
            this.m_root = any;
            this.m_objs.push(any);
            this.m_tags.push(qName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = this.m_tags.peek();
            if (parent instanceof Any) {
                Any any = this.buildAny(qName, attributes);
                ((Any)parent).addChild(any);
                this.m_objs.push(any);
                this.m_tags.push(qName);
            } else if (parent instanceof CodegenModel) {
                this.parseForCodegen((CodegenModel)parent, tag, qName, attributes);
            } else if (parent instanceof ManifestModel) {
                this.parseForManifest((ManifestModel)parent, tag, qName, attributes);
            } else if (parent instanceof FileModel) {
                this.parseForFile((FileModel)parent, tag, qName, attributes);
            } else if (parent instanceof StructureModel) {
                this.parseForStructure((StructureModel)parent, tag, qName, attributes);
            } else if (parent instanceof NodeModel) {
                this.parseForNode((NodeModel)parent, tag, qName, attributes);
            } else if (parent instanceof OutputsModel) {
                this.parseForOutputs((OutputsModel)parent, tag, qName, attributes);
            } else if (parent instanceof OutputModel) {
                this.parseForOutput((OutputModel)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof PropertyModel)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForProperty((PropertyModel)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

