/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.codegen;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.unidal.codegen.generator.GenerateContext;
import org.unidal.codegen.generator.GenerateContextSupport;
import org.unidal.codegen.generator.Generator;
import org.unidal.helper.Splitters;

public class DalModelMojo
extends AbstractMojo {
    protected Generator m_generator;
    protected MavenProject m_project;
    protected String sourceDir;
    protected String manifest;
    protected String resouceBase;
    protected boolean verbose;
    protected boolean debug;
    protected boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Model codegen was skipped explicitly.");
            return;
        }
        List parts = Splitters.by((char)',').noEmptyItem().trim().split(this.manifest);
        try {
            for (String part : parts) {
                this.generateModel(part);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Code generating failed.", e);
        }
    }

    private void generateModel(String manifest) throws MojoExecutionException, IOException, MalformedURLException, Exception {
        File manifestFile = new File(manifest);
        if (!manifestFile.exists()) {
            throw new MojoExecutionException(String.format("Manifest(%s) not found!", manifestFile.getCanonicalPath()));
        }
        final URL manifestXml = manifestFile.toURI().toURL();
        GenerateContextSupport ctx = new GenerateContextSupport(this.resouceBase, this.m_project.getBasedir()){

            protected void configure(Map<String, String> properties) {
                properties.put("src-main-java", DalModelMojo.this.sourceDir);
            }

            public URL getManifestXml() {
                return manifestXml;
            }

            public void log(GenerateContext.LogLevel logLevel, String message) {
                switch (logLevel) {
                    case DEBUG: {
                        if (!DalModelMojo.this.debug) break;
                        DalModelMojo.this.getLog().info((CharSequence)message);
                        break;
                    }
                    case INFO: {
                        if (!DalModelMojo.this.debug && !DalModelMojo.this.verbose) break;
                        DalModelMojo.this.getLog().info((CharSequence)message);
                        break;
                    }
                    case ERROR: {
                        DalModelMojo.this.getLog().error((CharSequence)message);
                    }
                }
            }
        };
        this.m_generator.generate((GenerateContext)ctx);
        this.m_project.addCompileSourceRoot(this.sourceDir);
        this.getLog().info((CharSequence)(ctx.getGeneratedFiles() + " files generated."));
    }
}

