/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.unidal.helper.Files;
import org.unidal.helper.Scanners;

public class WebModuleMojo
extends AbstractMojo {
    protected MavenProject m_project;
    protected boolean verbose;
    protected boolean debug;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String webappDir = this.m_project.getBuild().getDirectory() + "/" + this.m_project.getBuild().getFinalName();
            List classpathElements = this.m_project.getCompileClasspathElements();
            WebModuleResourceManager manager = new WebModuleResourceManager(webappDir, classpathElements);
            manager.process();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error when generating plexus components descriptor!", e);
        }
    }

    class WebModuleResourceManager {
        private File m_webappDir;
        private List<String> m_classpathElements;

        public WebModuleResourceManager(String webappDir, List<String> classpathElements) throws Exception {
            this.m_webappDir = new File(webappDir).getCanonicalFile();
            this.m_classpathElements = classpathElements;
        }

        public void process() throws Exception {
            for (String classpathElement : this.m_classpathElements) {
                this.processElement(new File(classpathElement).getCanonicalFile());
            }
        }

        private void processElement(File classpathElement) throws IOException {
            block4: {
                block3: {
                    if (classpathElement.isDirectory()) break block3;
                    List entries = Scanners.forJar().scan(classpathElement, (Scanners.IMatcher)new Scanners.FileMatcher(){

                        public Scanners.IMatcher.Direction matches(File base, String path) {
                            if (path.startsWith("WEB-MODULE")) {
                                return Scanners.IMatcher.Direction.MATCHED;
                            }
                            return Scanners.IMatcher.Direction.DOWN;
                        }
                    });
                    for (String entry : entries) {
                        URL url = new URL("jar:file:" + classpathElement + "!/" + entry);
                        File dst = new File(this.m_webappDir, entry.substring("WEB-MODULE".length()));
                        dst.getParentFile().mkdirs();
                        if (dst.exists()) continue;
                        Files.forIO().copy(url.openStream(), (OutputStream)new FileOutputStream(dst));
                    }
                    break block4;
                }
                File base = new File(classpathElement, "WEB-MODULE");
                if (!base.exists()) break block4;
                final ArrayList pathes = new ArrayList();
                Scanners.forDir().scan(base, (Scanners.IMatcher)new Scanners.FileMatcher(){

                    public Scanners.IMatcher.Direction matches(File base, String path) {
                        pathes.add(path);
                        return Scanners.IMatcher.Direction.DOWN;
                    }
                });
                for (String path : pathes) {
                    File src = new File(base, path);
                    File dst = new File(this.m_webappDir, path);
                    if (src.isDirectory()) {
                        dst.mkdirs();
                        continue;
                    }
                    if (dst.exists()) continue;
                    Files.forDir().copyFile(src, dst);
                }
            }
        }
    }
}

