/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.codegen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.unidal.codegen.meta.TableMeta;
import org.unidal.maven.plugin.common.PropertyProviders;

public class DalJdbcMetaMojo
extends AbstractMojo {
    protected MavenProject m_project;
    protected TableMeta m_meta;
    protected File baseDir;
    protected String driver;
    protected String url;
    protected String user;
    protected String password;
    protected String connectionProperties;
    protected List<String> includes;
    protected List<String> excludes;
    protected String outputDir;
    protected String packageName;

    private void validateParameters() {
        this.driver = this.getProperty(this.driver, "jdbc.driver", "JDBC driver:", "com.mysql.jdbc.Driver");
        this.url = this.getProperty(this.url, "jdbc.url", "JDBC URL[for example, jdbc:mysql://localhost:3306/test]:", null);
        this.user = this.getProperty(this.user, "jdbc.user", "JDBC user:", null);
        this.password = this.getProperty(this.password, "jdbc.password", "JDBC password:", null);
        this.connectionProperties = this.getProperty(this.connectionProperties, "jdbc.connectionProperties", "JDBC connection properties:", "useUnicode=true&autoReconnect=true");
        this.packageName = this.getProperty(this.packageName, "packageName", "Target package name:", null);
    }

    private String detectPackageName() {
        if (this.packageName != null) {
            return this.packageName;
        }
        String groupId = this.m_project.getGroupId();
        String artifactId = this.m_project.getArtifactId();
        return (groupId + "." + artifactId + ".dal").replace('-', '.');
    }

    private void resolveAliasConfliction(Element entities) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List children = entities.getChildren("entity");
        for (Element entity : children) {
            String alias = entity.getAttributeValue("alias");
            Integer count = (Integer)map.get(alias);
            if (count == null) {
                map.put(alias, 1);
                continue;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            map.put(alias, count);
            entity.setAttribute("alias", alias + count);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateParameters();
        Connection conn = this.setupConnection();
        try {
            File manifestFile;
            DatabaseMetaData meta = conn.getMetaData();
            List<String> tables = this.getTables(meta);
            Element entities = new Element("entities");
            for (String table : tables) {
                Element entity = this.m_meta.getTableMeta(meta, table);
                entities.addContent((Content)entity);
            }
            this.resolveAliasConfliction(entities);
            File outDir = this.getFile(this.outputDir);
            File outFile = new File(outDir, "codegen.xml");
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            this.saveFile(new Document(entities), outFile);
            File modelFile = new File(outDir, "dal.xml");
            if (!modelFile.exists()) {
                Document model = this.m_meta.getModel(this.detectPackageName());
                this.saveFile(model, modelFile);
            }
            if (!(manifestFile = new File(outDir, "manifest.xml")).exists()) {
                Document manifest = this.m_meta.getManifest(outFile.getName(), modelFile.getName());
                this.saveFile(manifest, manifestFile);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error when generating DAL meta: " + e, e);
        }
    }

    private String getProperty(String value, String name, String prompt, String defaultValue) {
        if (value != null) {
            return value;
        }
        return PropertyProviders.fromConsole().forString(name, prompt, defaultValue, null);
    }

    private Connection setupConnection() throws MojoExecutionException {
        Properties info = new Properties();
        info.put("user", this.user);
        info.put("password", this.password);
        if (this.connectionProperties != null) {
            String[] pairs;
            for (String pair : pairs = this.connectionProperties.split(Pattern.quote("&"))) {
                int pos = pair.indexOf(61);
                if (pos > 0) {
                    info.put(pair.substring(0, pos), pair.substring(pos + 1));
                    continue;
                }
                this.getLog().warn((CharSequence)("invalid property: " + pair + " ignored."));
            }
        }
        try {
            Class.forName(this.driver);
            return DriverManager.getConnection(this.url, info);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can't get connection: " + e, e);
        }
    }

    private File getFile(String path) {
        File file = path.startsWith("/") || path.indexOf(58) > 0 ? new File(path) : new File(this.baseDir, path);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(Document codegen, File file) throws IOException {
        Format format = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(format);
        FileWriter writer = new FileWriter(file);
        try {
            outputter.output(codegen, (Writer)writer);
            this.getLog().info((CharSequence)("File " + file.getCanonicalPath() + " generated."));
        }
        finally {
            writer.close();
        }
    }

    private List<String> getTables(DatabaseMetaData meta) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        if (this.includes == null) {
            this.includes = new ArrayList<String>();
            ResultSet rs = meta.getTables(null, null, "%", new String[]{"TABLE"});
            while (rs.next()) {
                String table = rs.getString("TABLE_NAME");
                tables.add(table);
            }
            rs.close();
        } else {
            for (String include : this.includes) {
                ResultSet rs = meta.getTables(null, null, include, new String[]{"TABLE"});
                while (rs.next()) {
                    String table = rs.getString("TABLE_NAME");
                    if (tables.contains(table)) continue;
                    tables.add(table);
                }
                rs.close();
            }
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                int index = tables.indexOf(exclude);
                if (index < 0) continue;
                tables.remove(index);
            }
        }
        Collections.sort(tables);
        return tables;
    }
}

