/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.codegen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.unidal.codegen.meta.ModelMeta;
import org.unidal.helper.Files;
import org.unidal.maven.plugin.common.PropertyProviders;

public class DalModelMetaMojo
extends AbstractMojo {
    protected MavenProject m_project;
    protected ModelMeta m_meta;
    protected File baseDir;
    protected String inputFile;
    protected String outputDir;
    protected String packageName;
    protected String prefix;

    private String defaultPackageName() {
        if (this.packageName != null) {
            return this.packageName;
        }
        String groupId = this.m_project.getGroupId();
        String artifactId = this.m_project.getArtifactId();
        return (groupId + "." + artifactId + ".model").replace('-', '.');
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String f = this.getProperty(this.inputFile, "inputFile", "Sample XML file path:", null);
        if (f == null) {
            throw new MojoExecutionException("please provide sample XML file path via -DinputFile=...");
        }
        try {
            File manifestFile;
            File inFile = this.getFile(f);
            String xml = Files.forIO().readFrom(inFile, "utf-8");
            Document doc = this.m_meta.getCodegen((Reader)new StringReader(xml));
            String rootName = this.getRootEntityName(doc);
            String p = this.getProperty(this.prefix, "prefix", "Prefix name of target files:", rootName);
            File outDir = this.getFile(this.outputDir);
            File outFile = new File(outDir, p == null ? "codegen.xml" : p + "-codegen.xml");
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            this.saveFile(doc, outFile);
            File modelFile = new File(outDir, p == null ? "model.xml" : p + "-model.xml");
            if (!modelFile.exists()) {
                String n = this.getProperty(this.packageName, "packageName", "Package name of generated model:", this.defaultPackageName());
                Document model = this.m_meta.getModel(n);
                this.saveFile(model, modelFile);
                File testResource = new File(this.m_project.getBasedir(), "src/test/resources");
                File testModel = new File(testResource, n.replace('.', '/') + "/" + rootName + ".xml");
                if (!testModel.exists()) {
                    testModel.getParentFile().mkdirs();
                    Files.forIO().writeTo(testModel, xml);
                    this.getLog().info((CharSequence)("File " + testModel.getCanonicalPath() + " generated."));
                }
            }
            if (!(manifestFile = new File(outDir, p == null ? "manifest.xml" : p + "-manifest.xml")).exists()) {
                Document manifest = this.m_meta.getManifest(outFile.getName(), modelFile.getName());
                this.saveFile(manifest, manifestFile);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error when generating model meta: " + e, e);
        }
    }

    private File getFile(String path) {
        File file = path.startsWith("/") || path.indexOf(58) > 0 ? new File(path) : new File(this.baseDir, path);
        return file;
    }

    private String getProperty(String value, String name, String prompt, String defaultValue) {
        if (value != null) {
            return value;
        }
        return PropertyProviders.fromConsole().forString(name, prompt, defaultValue, null);
    }

    private String getRootEntityName(Document doc) {
        List children = doc.getRootElement().getChildren();
        if (!children.isEmpty()) {
            Element first = (Element)children.get(0);
            return first.getAttributeValue("name");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(Document codegen, File file) throws IOException {
        Format format = Format.getPrettyFormat();
        XMLOutputter outputter = new XMLOutputter(format);
        FileWriter writer = new FileWriter(file);
        try {
            outputter.output(codegen, (Writer)writer);
            this.getLog().info((CharSequence)("File " + file.getCanonicalPath() + " generated."));
        }
        finally {
            writer.close();
        }
    }
}

