/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.unidal.codegen.generator.GenerateContext;
import org.unidal.codegen.generator.GenerateContextSupport;
import org.unidal.codegen.generator.Generator;
import org.unidal.codegen.manifest.ManifestCreator;
import org.unidal.codegen.meta.XmlMetaHelper;

public class DalXmlMojo
extends AbstractMojo {
    protected ManifestCreator m_manifestCreator;
    protected XmlMetaHelper m_xmlMetaHelper;
    protected Generator m_generator;
    protected MavenProject m_project;
    protected String sourceDir;
    protected String resouceBase;
    protected String manifest;
    protected String sourceInput;
    protected String sourcePackage;
    protected String sourceEncoding = "utf-8";
    protected boolean verbose;
    protected boolean debug;
    protected boolean skip;

    private String configurationTips(String[] variables, String[] properties) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<configuration>\r\n");
        for (String variable : variables) {
            sb.append("   <").append(variable).append(">VALUE<").append(variable).append(">\r\n");
        }
        sb.append("</configuration>\r\n");
        sb.append("\r\n-OR-\r\n\r\n");
        sb.append("on the command line, specify: '");
        boolean first = true;
        for (String property : properties) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append("-D").append(property).append("=VALUE");
        }
        sb.append("'\r\n");
        return sb.toString();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Model codegen was skipped explicitly.");
            return;
        }
        try {
            File manifestFile = new File(this.getManifest());
            if (!manifestFile.exists()) {
                throw new MojoFailureException(String.format("Manifest(%s) not found!", manifestFile.getCanonicalPath()));
            }
            final URL manifestXml = manifestFile.toURI().toURL();
            GenerateContextSupport ctx = new GenerateContextSupport(this.resouceBase, new File(this.sourceDir)){

                public URL getManifestXml() {
                    return manifestXml;
                }

                public void log(GenerateContext.LogLevel logLevel, String message) {
                    switch (logLevel) {
                        case DEBUG: {
                            if (!DalXmlMojo.this.debug) break;
                            DalXmlMojo.this.getLog().debug((CharSequence)message);
                            break;
                        }
                        case INFO: {
                            if (!DalXmlMojo.this.debug && !DalXmlMojo.this.verbose) break;
                            DalXmlMojo.this.getLog().info((CharSequence)message);
                            break;
                        }
                        case ERROR: {
                            DalXmlMojo.this.getLog().error((CharSequence)message);
                        }
                    }
                }
            };
            this.m_generator.generate((GenerateContext)ctx);
            this.m_project.addCompileSourceRoot(this.sourceDir);
            this.getLog().info((CharSequence)(ctx.getGeneratedFiles() + " files generated."));
        }
        catch (Exception e) {
            throw new MojoFailureException("Code generating failed.", (Throwable)e);
        }
    }

    private String getManifest() throws MojoExecutionException {
        if (this.sourceInput != null && this.sourcePackage != null) {
            String userContent = "<?xml version=\"1.0\" encoding=\"utf-8\"?><root do-package=\"" + this.sourcePackage + "\"/>";
            try {
                Reader reader = this.getSourceReader();
                String xmlMetaContent = this.m_xmlMetaHelper.getXmlMetaContent(reader);
                return this.m_manifestCreator.create(xmlMetaContent, userContent);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Can't create manifest file by " + this.sourceInput + " and " + this.sourcePackage, e);
            }
        }
        if (this.manifest != null) {
            return this.manifest;
        }
        throw new MojoExecutionException("One of followings must be specified:\r\n" + this.configurationTips(new String[]{"manifest"}, new String[]{"manifest"}) + "\r\nor\r\n\r\n" + this.configurationTips(new String[]{"sourceInput", "sourcePackage"}, new String[]{"source.input", "source.package"}));
    }

    private Reader getSourceReader() throws UnsupportedEncodingException, FileNotFoundException, IOException, MalformedURLException {
        InputStreamReader reader;
        if (new File(this.sourceInput).exists()) {
            reader = new InputStreamReader((InputStream)new FileInputStream(this.sourceInput), this.sourceEncoding);
        } else if (new File(this.m_project.getBasedir(), this.sourceInput).exists()) {
            reader = new InputStreamReader((InputStream)new FileInputStream(new File(this.m_project.getBasedir(), this.sourceInput)), this.sourceEncoding);
        } else {
            URLConnection conn = new URL(this.sourceInput).openConnection();
            reader = new InputStreamReader(conn.getInputStream(), this.sourceEncoding);
        }
        return reader;
    }
}

