<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:c="org.unidal.maven.plugin.codegen.function.Collection" extension-element-prefixes="c">
<xsl:output method="html" indent="no" media-type="text/plain" encoding="utf-8"/>
<xsl:param name="package"/>
<xsl:variable name="space" select="' '"/>
<xsl:variable name="empty" select="''"/>
<xsl:variable name="empty-line" select="'&#x0A;'"/>

<xsl:template match="/">
   <xsl:apply-templates select="/model"/>
</xsl:template>

<xsl:template match="model">
   <xsl:value-of select="$empty"/>/* THIS FILE WAS AUTO GENERATED BY codegen-maven-plugin, DO NOT EDIT IT */<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>package <xsl:value-of select="$package"/>;<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>public class Constants {<xsl:value-of select="$empty-line"/>
   <xsl:call-template name='constant-attributes'/>
   <xsl:call-template name='constant-elements'/>
   <xsl:call-template name='constant-entities'/>
   <xsl:value-of select="$empty"/>}<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="c:reset()" />
</xsl:template>

<xsl:template name="constant-attributes">
   <xsl:for-each select="entity/attribute[not(@text='true' or @render='false')]">
      <xsl:sort select="@upper-name"/>

	  <xsl:if test="c:addIfAbsent(@upper-name)">
         <xsl:value-of select="$empty-line"/>
         <xsl:value-of select="$empty"/>   public static final String <xsl:value-of select="@upper-name"/> = "<xsl:value-of select="@name"/>";<xsl:value-of select="$empty-line"/>
	  </xsl:if>
   </xsl:for-each>
</xsl:template>

<xsl:template name="constant-elements">
   <xsl:for-each select="entity/element[not(@render='false')]">
      <xsl:sort select="@upper-name"/>

      <xsl:choose>
            <xsl:when test="@text='true' and @alias">
			  <xsl:if test="c:addIfAbsent(@upper-name-element)">
		         <xsl:value-of select="$empty-line"/>
		         <xsl:value-of select="$empty"/>   public static final String <xsl:value-of select="@upper-name-element"/> = "<xsl:value-of select="@alias"/>";<xsl:value-of select="$empty-line"/>
			  </xsl:if>
            </xsl:when>
            <xsl:otherwise>
			  <xsl:if test="c:addIfAbsent(@upper-name-element)">
		         <xsl:value-of select="$empty-line"/>
		         <xsl:value-of select="$empty"/>   public static final String <xsl:value-of select="@upper-name-element"/> = "<xsl:value-of select="@name"/>";<xsl:value-of select="$empty-line"/>
			  </xsl:if>
            </xsl:otherwise>
         </xsl:choose>
	  <xsl:if test="c:addIfAbsent(@upper-name)">
         <xsl:value-of select="$empty-line"/>
         <xsl:value-of select="$empty"/>   public static final String <xsl:value-of select="@upper-name"/> = "<xsl:value-of select="@tag-name"/>";<xsl:value-of select="$empty-line"/>
	  </xsl:if>
   </xsl:for-each>
</xsl:template>

<xsl:template name="constant-entities">
   <xsl:for-each select="entity">
      <xsl:sort select="@upper-name"/>

	  <xsl:if test="c:addIfAbsent(@upper-name)">
         <xsl:value-of select="$empty-line"/>
         <xsl:value-of select="$empty"/>   public static final String <xsl:value-of select="@upper-name"/> = "<xsl:value-of select="@tag-name"/>";<xsl:value-of select="$empty-line"/>
	  </xsl:if>
   </xsl:for-each>
   <xsl:for-each select="entity/entity-ref[not(@render='false')]">
      <xsl:sort select="@upper-name"/>

	  <xsl:if test="c:addIfAbsent(@upper-name)">
         <xsl:value-of select="$empty-line"/>
         <xsl:value-of select="$empty"/>   public static final String <xsl:value-of select="@upper-name"/> = "<xsl:value-of select="@tag-name"/>";<xsl:value-of select="$empty-line"/>
	  </xsl:if>
	  <xsl:if test="c:addIfAbsent(@upper-names)">
         <xsl:value-of select="$empty-line"/>
         <xsl:value-of select="$empty"/>   public static final String <xsl:value-of select="@upper-names"/> = "<xsl:value-of select="@tag-names"/>";<xsl:value-of select="$empty-line"/>
	  </xsl:if>
   </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
