<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="common.xsl"/>
<xsl:output method="html" indent="no" media-type="text/plain" encoding="utf-8"/>
<xsl:param name="package"/>
<xsl:variable name="space" select="' '"/>
<xsl:variable name="empty" select="''"/>
<xsl:variable name="empty-line" select="'&#x0A;'"/>
<xsl:variable name="class-name" select="//entity[@root='true']/@class-name"/>
<xsl:variable name="with-xml-builder" select="/model[@enable-xml='true' or @enable-xml-builder='true']"/>
<xsl:variable name="with-xml-parser" select="/model[@enable-xml='true' or @enable-xml-parser='true']"/>
<xsl:variable name="with-json-builder" select="/model[@enable-json='true' or @enable-json-builder='true']"/>
<xsl:variable name="with-json-parser" select="/model[@enable-json='true' or @enable-json-parser='true']"/>
<xsl:variable name="with-native-builder" select="/model[@enable-native='true' or @enable-native-builder='true']"/>
<xsl:variable name="with-native-parser" select="/model[@enable-native='true' or @enable-native-parser='true']"/>

<xsl:template match="/">
   <xsl:apply-templates select="/model"/>
</xsl:template>

<xsl:template match="model">
   <xsl:value-of select="$empty"/>/* THIS FILE WAS AUTO GENERATED BY codegen-maven-plugin, DO NOT EDIT IT */<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>package <xsl:value-of select="$package"/>;<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty-line"/>
   <xsl:call-template name='import-list'/>
   <xsl:value-of select="$empty"/>public class <xsl:value-of select="$class-name"/>Helper {<xsl:value-of select="$empty"/>

<xsl:if test="$with-json-builder">
   public static String asJson(IEntity<xsl:value-of select="'&lt;?&gt;'" disable-output-escaping="yes"/> entity) {
      return new DefaultJsonBuilder().build(entity);
   }
</xsl:if>
<xsl:if test="$with-native-builder">
   public static byte[] asNative(IEntity<xsl:value-of select="'&lt;?&gt;'" disable-output-escaping="yes"/> entity) {
      ByteArrayOutputStream out = new ByteArrayOutputStream(8192);

      new DefaultNativeBuilder().build(entity, out);
      return out.toByteArray();
   }

   public static void asNative(IEntity<xsl:value-of select="'&lt;?&gt;'" disable-output-escaping="yes"/> entity, OutputStream out) {
      new DefaultNativeBuilder().build(entity, out);
   }
</xsl:if>
<xsl:if test="$with-xml-builder">
   public static String asXml(IEntity<xsl:value-of select="'&lt;?&gt;'" disable-output-escaping="yes"/> entity) {
      return new DefaultXmlBuilder().build(entity);
   }
</xsl:if>

<xsl:if test="$with-native-parser">
   public static <xsl:value-of select="'&lt;T extends IEntity&lt;?&gt;&gt;'" disable-output-escaping="yes"/> T fromNative(Class<xsl:value-of select="'&lt;T&gt;'" disable-output-escaping="yes"/> entityType, InputStream in) throws IOException {
      <xsl:value-of select="$empty"/>      try {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>         T entity = entityType.getConstructor().newInstance();<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>         new DefaultNativeParser().parse(entity, in);<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>         return entity;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      } catch (RuntimeException e) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>         if (e.getCause() instanceof IOException) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>            throw (IOException) e.getCause();<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>         } else {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>            throw e;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      } catch (Exception e) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>         throw new RuntimeException(e);<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
   }

   public static void fromNative(IEntity<xsl:value-of select="'&lt;?&gt;'" disable-output-escaping="yes"/> entity, InputStream in) throws IOException {
      new DefaultNativeParser().parse(entity, in);
   }

   public static <xsl:value-of select="$class-name"/> fromNative(InputStream in) throws IOException {
      return fromNative(<xsl:value-of select="$class-name"/>.class, in);
   }<xsl:value-of select="$empty-line"/>
</xsl:if>
<xsl:if test="$with-xml-parser">
   public static <xsl:value-of select="'&lt;T extends IEntity&lt;?&gt;&gt;'" disable-output-escaping="yes"/> T fromXml(Class<xsl:value-of select="'&lt;T&gt;'" disable-output-escaping="yes"/> entityType, InputStream in) throws IOException {
      return new DefaultXmlParser().parse(entityType, new InputSource(withoutBom(in)));
   }

   public static <xsl:value-of select="'&lt;T extends IEntity&lt;?&gt;&gt;'" disable-output-escaping="yes"/> T fromXml(Class<xsl:value-of select="'&lt;T&gt;'" disable-output-escaping="yes"/> entityType, String xml) throws IOException {
      return new DefaultXmlParser().parse(entityType, new InputSource(new StringReader(xml)));
   }

   public static <xsl:value-of select="$class-name"/> fromXml(InputStream in) throws IOException {
      return fromXml(<xsl:value-of select="$class-name"/>.class, in);
   }

   public static <xsl:value-of select="$class-name"/> fromXml(String xml) throws IOException {
      return fromXml(<xsl:value-of select="$class-name"/>.class, xml);
   }

   /**
    * removes Byte Order Mark(BOM) at the head of windows UTF-8 file.
    */
   private static InputStream withoutBom(InputStream in) throws IOException {
      if (!(in instanceof BufferedInputStream)) {
         in = new BufferedInputStream(in);
      }

      in.mark(3);

      /** UTF-8, with BOM **/
      if (in.read() != 0xEF || in.read() != 0xBB || in.read() != 0xBF) {
         in.reset();
      }

      return in;
   }<xsl:value-of select="$empty-line"/>
</xsl:if>

   <xsl:value-of select="$empty"/>}<xsl:value-of select="$empty-line"/>
</xsl:template>

<xsl:template name="import-list">
   <xsl:if test="$with-xml-parser">
      <xsl:value-of select="$empty"/>import java.io.BufferedInputStream;<xsl:value-of select="$empty-line"/>
   </xsl:if>

   <xsl:if test="$with-native-builder">
      <xsl:value-of select="$empty"/>import java.io.ByteArrayOutputStream;<xsl:value-of select="$empty-line"/>
   </xsl:if>

   <xsl:if test="$with-xml-parser or $with-native-parser">
      <xsl:value-of select="$empty"/>import java.io.IOException;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>import java.io.InputStream;<xsl:value-of select="$empty-line"/>
   </xsl:if>

   <xsl:if test="$with-native-parser">
      <xsl:value-of select="$empty"/>import java.io.OutputStream;<xsl:value-of select="$empty-line"/>
   </xsl:if>
   
   <xsl:if test="$with-xml-parser">
      <xsl:value-of select="$empty"/>import java.io.StringReader;<xsl:value-of select="$empty-line"/>
   </xsl:if>

   <xsl:value-of select="$empty-line"/>

   <xsl:if test="$with-xml-parser or $with-native-parser">
      <xsl:value-of select="$empty"/>import <xsl:value-of select="$package"/>.entity.<xsl:value-of select="$class-name"/>;<xsl:value-of select="$empty-line"/>
   </xsl:if>

   <xsl:if test="$with-json-builder">
      <xsl:value-of select="$empty"/>import <xsl:value-of select="$package"/>.transform.DefaultJsonBuilder;<xsl:value-of select="$empty-line"/>
   </xsl:if>

   <xsl:if test="$with-native-builder">
      <xsl:value-of select="$empty"/>import <xsl:value-of select="$package"/>.transform.DefaultNativeBuilder;<xsl:value-of select="$empty-line"/>
   </xsl:if>

   <xsl:if test="$with-native-parser">
      <xsl:value-of select="$empty"/>import <xsl:value-of select="$package"/>.transform.DefaultNativeParser;<xsl:value-of select="$empty-line"/>
   </xsl:if>

   <xsl:if test="$with-xml-builder">
      <xsl:value-of select="$empty"/>import <xsl:value-of select="$package"/>.transform.DefaultXmlBuilder;<xsl:value-of select="$empty-line"/>
    </xsl:if>

   <xsl:if test="$with-xml-parser">
      <xsl:value-of select="$empty"/>import <xsl:value-of select="$package"/>.transform.DefaultXmlParser;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>import org.xml.sax.InputSource;<xsl:value-of select="$empty-line"/>
    </xsl:if>

   <xsl:value-of select="$empty-line"/>
</xsl:template>

</xsl:stylesheet>
