/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.codegen;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.unidal.codegen.framework.GenerationContext;
import org.unidal.codegen.framework.XslGenerator;
import org.unidal.helper.Splitters;
import org.unidal.maven.plugin.codegen.DalMojoSupport;

public class DalJdbcMojo
extends DalMojoSupport {
    private XslGenerator m_generator;
    private String sourceDir;
    private String manifest;
    private boolean skip;
    private boolean test;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"DAL JDBC code generation is skipped explicitly.");
            return;
        }
        try {
            List files = Splitters.by((char)',').noEmptyItem().trim().split(this.manifest);
            for (String file : files) {
                this.generateJdbc(file);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error when generating code due to " + e, e);
        }
    }

    private void generateJdbc(String manifest) throws Exception {
        File manifestFile = new File(manifest);
        if (!manifestFile.exists()) {
            throw new IllegalStateException(String.format("Manifest(%s) is not found!", manifestFile.getCanonicalPath()));
        }
        GenerationContext ctx = super.createContext(manifestFile, this.sourceDir);
        this.m_generator.generate(ctx);
        if (this.test) {
            this.getProject().addTestCompileSourceRoot(this.sourceDir);
        } else {
            this.getProject().addCompileSourceRoot(this.sourceDir);
        }
    }

    @Override
    protected String getCodegenType() {
        return "jdbc";
    }
}

