/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.codegen;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.unidal.codegen.framework.GenerationContext;
import org.unidal.codegen.framework.GenerationContextSupport;

public abstract class DalMojoSupport
extends AbstractMojo {
    private MavenProject m_project;
    private boolean verbose;
    private boolean debug;

    protected GenerationContext createContext(File manifestFile, String sourceDir) throws IOException {
        String resourceBase = String.format("/META-INF/dal/%s/xsl", this.getCodegenType());
        return new DalMojoGenerationContext(resourceBase, manifestFile, sourceDir);
    }

    protected abstract String getCodegenType();

    public MavenProject getProject() {
        return this.m_project;
    }

    protected class DalMojoGenerationContext
    extends GenerationContextSupport {
        private final File m_manifestXml;
        private String m_resourceBasePath;
        private AtomicInteger m_generatedFiles;

        public DalMojoGenerationContext(String resourceBasePath, File manifestXml, String sourceDir) throws IOException {
            super(DalMojoSupport.this.m_project.getBasedir());
            this.m_generatedFiles = new AtomicInteger();
            this.m_resourceBasePath = resourceBasePath;
            this.m_manifestXml = manifestXml;
            this.getProperties().put("src-main-java", sourceDir);
        }

        public void debug(String message) {
            if (DalMojoSupport.this.debug) {
                this.info(message);
            }
        }

        public AtomicInteger getGeneratedFiles() {
            return this.m_generatedFiles;
        }

        public File getManifestXml() {
            return this.m_manifestXml;
        }

        protected URL getResource(String name) {
            String path = this.m_resourceBasePath + "/" + name;
            try {
                path = new File(path).getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            URL url = ((Object)((Object)this)).getClass().getResource(path);
            if (url != null) {
                return url;
            }
            throw new RuntimeException("Can't find resource: " + path);
        }

        public void info(String message) {
            DalMojoSupport.this.getLog().info((CharSequence)message);
        }

        public void verbose(String message) {
            if (DalMojoSupport.this.debug || DalMojoSupport.this.verbose) {
                this.info(message);
            }
        }
    }
}

