/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.aggregator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.unidal.codegen.aggregator.XmlAggregator;
import org.unidal.codegen.aggregator.XmlHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DefaultXmlAggregator
implements XmlAggregator {
    private String m_structureFile;

    @Override
    public String aggregate(File manifestXml) {
        try {
            return this.aggregate(manifestXml.toURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String aggregate(URL manifestXml) {
        if (this.m_structureFile == null) {
            throw new RuntimeException("Please config structureFile property first.");
        }
        Manifest manifest = this.parseManifest(manifestXml);
        List<File> files = manifest.getFiles();
        Node root = new Node(this.getNodeDefinition());
        try {
            for (int i = 0; i < files.size(); ++i) {
                File file = files.get(i);
                NodeParser parser = new NodeParser();
                parser.setRootNode(root);
                parser.parse(file.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        StringBuilder sb = new StringBuilder(65536);
        root.buildXml(sb, -1, "   ");
        return sb.toString();
    }

    private NodeDefinition getNodeDefinition() {
        InputStream in = this.getClass().getResourceAsStream(this.m_structureFile);
        if (in == null) {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.m_structureFile);
        }
        if (in == null) {
            throw new RuntimeException("Unable to find property file: " + this.m_structureFile);
        }
        try {
            NodeDefinitionParser parser = new NodeDefinitionParser();
            NodeDefinition root = new NodeDefinition("", null, false);
            parser.setRoot(root);
            parser.parse(in);
            NodeDefinition nodeDefinition = root;
            return nodeDefinition;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Manifest parseManifest(URL manifestXml) {
        try {
            File dir = new File(manifestXml.getFile()).getParentFile();
            ManifestParser parser = new ManifestParser();
            Manifest manifest = new Manifest(dir);
            parser.setManifest(manifest);
            parser.parse(manifestXml);
            return manifest;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setStructureFile(String structureFile) {
        this.m_structureFile = structureFile;
    }

    static class NodeParser
    extends XmlHandler {
        private Stack<Node> m_nodes = new Stack();
        private Stack<NodeDefinition> m_defs = new Stack();
        private Node m_root;
        private NodeDefinition m_definition;

        NodeParser() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String text = new String(ch, start, length);
            if (text.trim().length() > 0) {
                Node current = this.m_nodes.peek();
                current.setText(text);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
            this.m_nodes.pop();
            this.m_defs.pop();
        }

        public void setRootNode(Node root) {
            this.m_root = root;
            this.m_definition = root.getDefinition();
            this.m_nodes.push(this.m_root);
            this.m_defs.push(this.m_definition);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
            try {
                NodeDefinition parentDef = this.m_defs.peek();
                NodeDefinition childDef = parentDef == null ? null : parentDef.findChildNodeDefinition(localName);
                Node parent = this.m_nodes.peek();
                Node child = childDef == null ? new Node(localName) : new Node(childDef);
                child.loadAttributes(attrs);
                Node node = parent.findChildByKeyValue(localName, child.getKeyValue());
                if (node == null) {
                    parent.addChild(child);
                    this.m_nodes.push(child);
                } else {
                    node.mergeAttributes(child);
                    this.m_nodes.push(node);
                }
                this.m_nodes.peek().setOverwriteText(true);
                this.m_defs.push(childDef);
            }
            catch (RuntimeException e) {
                throw new SAXException(e);
            }
        }
    }

    static class NodeDefinitionParser
    extends XmlHandler {
        private Stack<NodeDefinition> m_objs = new Stack();
        private NodeDefinition m_root;

        NodeDefinitionParser() {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
            this.m_objs.pop();
        }

        public void setRoot(NodeDefinition root) {
            this.m_root = root;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
            block6: {
                String tag = localName;
                try {
                    if (tag.equals("root")) {
                        if (this.m_objs.isEmpty()) {
                            this.m_objs.push(this.m_root);
                            break block6;
                        }
                        throw new SAXException(tag + " must be first element");
                    }
                    if (tag.equals("node")) {
                        NodeDefinition parent = this.m_objs.peek();
                        String name = attrs.getValue("name");
                        if (name == null) {
                            throw new SAXException("attribute name is not specified under " + parent);
                        }
                        String keyName = attrs.getValue("key");
                        String noNamespace = attrs.getValue("no-namespace");
                        NodeDefinition child = new NodeDefinition(name, keyName, "true".equals(noNamespace));
                        parent.addChildNodeDefinition(child);
                        this.m_objs.push(child);
                        break block6;
                    }
                    String location = this.m_objs.isEmpty() ? "" : " under " + this.m_objs.peek();
                    throw new SAXException("Unknown tag(" + rawName + ") is found" + location);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw new SAXException(e);
                }
            }
        }
    }

    static class NodeDefinition {
        private String m_name;
        private String m_keyName;
        private boolean m_noNamespace;
        private Map<String, NodeDefinition> m_children;

        public NodeDefinition(String name, String keyName, boolean noNamespace) {
            this.m_name = name;
            this.m_keyName = keyName;
            this.m_noNamespace = noNamespace;
            this.m_children = new HashMap<String, NodeDefinition>();
        }

        public void addChildNodeDefinition(NodeDefinition child) {
            this.m_children.put(child.getName(), child);
        }

        public NodeDefinition findChildNodeDefinition(String name) {
            return this.m_children.get(name);
        }

        public String getKeyValue(Attributes attrs) {
            String[] names;
            if (this.m_keyName == null) {
                return "";
            }
            int length = attrs.getLength();
            for (String name : names = this.m_keyName.split(",")) {
                for (int i = 0; i < length; ++i) {
                    String attrName = attrs.getQName(i);
                    if (!attrName.equals(name)) continue;
                    String value = attrs.getValue(i);
                    return value;
                }
            }
            return "";
        }

        public String getName() {
            return this.m_name;
        }

        public boolean hasNoNamespace() {
            return this.m_noNamespace;
        }

        public String toString() {
            return this.m_name + "[" + this.m_keyName + "]";
        }
    }

    static class Node {
        private String m_name;
        private List<String> m_attrNames = new ArrayList<String>();
        private List<String> m_attrValues = new ArrayList<String>();
        private List<Node> m_children = new ArrayList<Node>();
        private String m_keyValue;
        private NodeDefinition m_definition;
        private String m_text;
        private boolean m_overwriteText;

        public Node(NodeDefinition definition) {
            this.m_definition = definition;
            this.m_name = definition.getName();
        }

        public Node(String name) {
            this.m_name = name;
        }

        public void addChild(Node child) {
            this.m_children.add(child);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void buildXml(StringBuilder sb, int level, String indent) {
            StringBuilder stringBuilder = sb;
            synchronized (stringBuilder) {
                int offset = sb.length();
                for (int i = 0; i < level; ++i) {
                    sb.append(indent);
                }
                String allIndent = sb.substring(offset);
                if (this.m_name.length() > 0) {
                    sb.append("<").append(this.m_name);
                }
                boolean noNamespace = this.m_definition != null && this.m_definition.hasNoNamespace();
                int size = this.m_attrNames.size();
                for (int i = 0; i < size; ++i) {
                    String name = this.m_attrNames.get(i);
                    if (noNamespace && (name.endsWith("xmlns") || name.indexOf(58) > 0)) continue;
                    sb.append(' ').append(name).append("=\"");
                    sb.append(this.escape(this.m_attrValues.get(i))).append("\"");
                }
                int len = this.m_children.size();
                if (len == 0) {
                    if (this.m_text == null) {
                        sb.append("/>\r\n");
                    } else {
                        sb.append("><![CDATA[\r\n");
                        sb.append(this.m_text);
                        sb.append(allIndent).append("]]></");
                        sb.append(this.m_name).append(">\r\n");
                    }
                } else if (this.m_name.length() > 0) {
                    sb.append(">\r\n");
                    for (int i = 0; i < len; ++i) {
                        Node child = this.m_children.get(i);
                        child.buildXml(sb, level + 1, indent);
                    }
                    sb.append(allIndent).append("</");
                    sb.append(this.m_name).append(">\r\n");
                } else {
                    for (int i = 0; i < len; ++i) {
                        Node child = this.m_children.get(i);
                        child.buildXml(sb, level + 1, indent);
                    }
                }
            }
        }

        private String escape(Object value) {
            if (value == null) {
                return null;
            }
            String str = value.toString();
            int len = str.length();
            StringBuilder sb = new StringBuilder(len + 16);
            block6: for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                switch (ch) {
                    case '<': {
                        sb.append("&lt;");
                        continue block6;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block6;
                    }
                    case '&': {
                        sb.append("&amp;");
                        continue block6;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        continue block6;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            return sb.toString();
        }

        public Node findChildByKeyValue(String nodeName, String keyValue) {
            if (keyValue == null) {
                return null;
            }
            int index = this.findIndexByKeyValue(nodeName, keyValue);
            if (index >= 0) {
                return this.m_children.get(index);
            }
            return null;
        }

        private int findIndexByKeyValue(String nodeName, String keyValue) {
            int size = this.m_children.size();
            for (int i = 0; i < size; ++i) {
                Node child = this.m_children.get(i);
                if (!child.getName().equals(nodeName) || !keyValue.equals(child.getKeyValue())) continue;
                return i;
            }
            return -1;
        }

        public NodeDefinition getDefinition() {
            return this.m_definition;
        }

        public String getKeyValue() {
            return this.m_keyValue;
        }

        public String getName() {
            return this.m_name;
        }

        public Object getText() {
            return this.m_text;
        }

        public boolean isOverwriteText() {
            return this.m_overwriteText;
        }

        public void loadAttributes(Attributes attrs) {
            int length = attrs.getLength();
            for (int i = 0; i < length; ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                this.m_attrNames.add(name);
                this.m_attrValues.add(value);
            }
            if (this.m_definition != null) {
                this.m_keyValue = this.m_definition.getKeyValue(attrs);
            }
        }

        public void mergeAttributes(Node child) {
            List<String> attrNames = child.m_attrNames;
            List<String> attrValues = child.m_attrValues;
            int size = attrNames.size();
            int len = this.m_attrNames.size();
            for (int i = 0; i < size; ++i) {
                String name = attrNames.get(i);
                String value = attrValues.get(i);
                boolean found = false;
                for (int j = 0; j < len; ++j) {
                    String attrName = this.m_attrNames.get(j);
                    if (!attrName.equals(name)) continue;
                    this.m_attrValues.set(j, value);
                    found = true;
                    break;
                }
                if (found) continue;
                this.m_attrNames.add(name);
                this.m_attrValues.add(value);
            }
        }

        public void setOverwriteText(boolean overwriteText) {
            this.m_overwriteText = overwriteText;
        }

        public void setText(String text) {
            if (this.m_overwriteText) {
                this.m_text = null;
                this.m_overwriteText = false;
            }
            this.m_text = this.m_text == null ? text : this.m_text + text;
        }

        public String toString() {
            return this.m_name + "[" + this.m_keyValue + "]";
        }
    }

    static class ManifestParser
    extends XmlHandler {
        private Stack<Object> m_objs = new Stack();
        private Stack<String> m_tags = new Stack();
        private Manifest m_manifest;

        ManifestParser() {
        }

        @Override
        public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
            this.m_objs.pop();
            this.m_tags.pop();
        }

        public void setManifest(Manifest manifest) {
            this.m_manifest = manifest;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
            String tag;
            block5: {
                tag = localName;
                try {
                    if (tag.equals("manifest")) {
                        if (this.m_tags.isEmpty()) {
                            this.m_objs.push(this.m_manifest);
                            break block5;
                        }
                        throw new SAXException(tag + " must be first element of document");
                    }
                    if (tag.equals("file")) {
                        Manifest parent = (Manifest)this.m_objs.peek();
                        String file = attrs.getValue("path");
                        parent.addFile(file);
                        this.m_objs.push(tag);
                        break block5;
                    }
                    String location = this.m_objs.isEmpty() ? "" : " under " + this.m_objs.peek();
                    throw new SAXException("Unknown tag(" + rawName + ") is found" + location);
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw new SAXException(e);
                }
            }
            this.m_tags.push(tag);
        }
    }

    static class Manifest {
        private File m_baseDir;
        private List<File> m_files = new ArrayList<File>();

        public Manifest(File baseDir) {
            this.m_baseDir = baseDir;
        }

        public void addFile(String file) {
            this.m_files.add(new File(this.m_baseDir, file));
        }

        public List<File> getFiles() {
            return this.m_files;
        }
    }
}

