/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.generator;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.unidal.codegen.generator.GenerateContext;
import org.unidal.codegen.manifest.FileMode;
import org.unidal.codegen.manifest.Manifest;
import org.unidal.helper.Files;
import org.unidal.helper.Scanners;
import org.unidal.tuple.Pair;

public abstract class GenerateContextSupport
implements GenerateContext {
    private File m_projectBaseDir;
    private String m_resourceBasePath;
    private int m_generatedFiles;
    private Map<String, String> m_properties;

    public GenerateContextSupport(String resourceBasePath, File projectBaseDir) throws IOException {
        this.m_projectBaseDir = projectBaseDir.getCanonicalFile();
        this.m_resourceBasePath = resourceBasePath;
        this.m_properties = new HashMap<String, String>();
        this.m_properties.put("base-dir", this.m_projectBaseDir.getPath());
        this.m_properties.put("src-main-java", "src/main/java");
        this.m_properties.put("src-main-resources", "src/main/resources");
        this.m_properties.put("src-main-webapp", "src/main/webapp");
        this.m_properties.put("src-test-java", "src/test/java");
        this.m_properties.put("src-test-resources", "src/test/resources");
        this.configure(this.m_properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.m_properties;
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.m_properties.get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public File getPath(String name) {
        if (name.startsWith("/") || name.contains(":")) {
            return new File(name);
        }
        return new File(this.m_projectBaseDir, name);
    }

    protected void configure(Map<String, String> properties) {
    }

    @Override
    public void addFileToStorage(Manifest manifest, String content) throws IOException {
        FileMode mode = manifest.getMode();
        File file = this.getPath(manifest.getPath()).getCanonicalFile();
        file.getParentFile().mkdirs();
        switch (mode) {
            case CREATE_OR_OVERWRITE: {
                Files.forIO().writeTo(file, content);
                this.log(GenerateContext.LogLevel.INFO, file + " generated");
                ++this.m_generatedFiles;
                break;
            }
            case CREATE_IF_NOT_EXISTS: {
                if (file.exists()) break;
                Files.forIO().writeTo(file, content);
                this.log(GenerateContext.LogLevel.INFO, file + " generated");
                ++this.m_generatedFiles;
            }
        }
    }

    @Override
    public void closeStorage() throws IOException {
    }

    private void copyFile(final FileMode mode, String from, final File to) throws IOException {
        int pos = from.indexOf(".jar!");
        if (pos > 0 && from.startsWith("file:")) {
            File jarFile = new File(from.substring(5, pos + 4));
            final String prefix = from.substring(pos + 6);
            final ArrayList list = new ArrayList();
            Scanners.forJar().scan(jarFile, (Scanners.IMatcher)new Scanners.FileMatcher(){

                public Scanners.IMatcher.Direction matches(File base, String path) {
                    if (path.equals(prefix)) {
                        int pos = path.lastIndexOf(47);
                        String relativePath = path.substring(pos + 1);
                        File target = new File(to, relativePath);
                        switch (mode) {
                            case CREATE_IF_NOT_EXISTS: {
                                if (target.exists()) break;
                            }
                            case CREATE_OR_OVERWRITE: {
                                list.add(new Pair((Object)target, (Object)path));
                                break;
                            }
                        }
                    } else if (path.startsWith(prefix)) {
                        String relativePath = path.substring(prefix.length() + 1);
                        File target = new File(to, relativePath);
                        switch (mode) {
                            case CREATE_IF_NOT_EXISTS: {
                                if (target.exists()) break;
                            }
                            case CREATE_OR_OVERWRITE: {
                                list.add(new Pair((Object)target, (Object)path));
                                break;
                            }
                        }
                    }
                    return Scanners.IMatcher.Direction.NEXT;
                }
            });
            for (Pair item : list) {
                File target = (File)item.getKey();
                String jarUrl = jarFile.toURI().toURL().toExternalForm();
                byte[] data = Files.forIO().readFrom(new URL("jar:" + jarUrl + "!/" + (String)item.getValue()).openStream());
                Files.forIO().writeTo(target, data);
                this.log(GenerateContext.LogLevel.INFO, target + " generated");
                ++this.m_generatedFiles;
            }
        } else {
            final ArrayList list = new ArrayList();
            File base = new File(from);
            if (base.isDirectory()) {
                Scanners.forDir().scan(base, (Scanners.IMatcher)new Scanners.FileMatcher(){

                    public Scanners.IMatcher.Direction matches(File base, String path) {
                        if (new File(base, path).isFile()) {
                            list.add(path);
                        }
                        return Scanners.IMatcher.Direction.DOWN;
                    }
                });
                for (String item : list) {
                    File target = new File(to, item);
                    File source = new File(from, item);
                    switch (mode) {
                        case CREATE_IF_NOT_EXISTS: {
                            if (target.exists()) break;
                        }
                        case CREATE_OR_OVERWRITE: {
                            byte[] data = Files.forIO().readFrom(source);
                            Files.forIO().writeTo(target, data);
                            this.log(GenerateContext.LogLevel.INFO, target + " generated");
                            ++this.m_generatedFiles;
                            break;
                        }
                    }
                }
            } else if (base.isFile()) {
                File target = new File(to, base.getName());
                File source = base;
                switch (mode) {
                    case CREATE_IF_NOT_EXISTS: {
                        if (target.exists()) break;
                    }
                    case CREATE_OR_OVERWRITE: {
                        byte[] data = Files.forIO().readFrom(source);
                        Files.forIO().writeTo(target, data);
                        this.log(GenerateContext.LogLevel.INFO, target + " generated");
                        ++this.m_generatedFiles;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void copyFileToStorage(Manifest manifest) throws IOException {
        FileMode mode = manifest.getMode();
        String from = manifest.getTemplate();
        String to = manifest.getPath();
        if (from == null || to == null) {
            throw new IllegalArgumentException(String.format("Property template(%s) and path(%s) must be both specified!", from, to));
        }
        File toFile = this.getPath(to).getCanonicalFile();
        URL url = this.getResource(from);
        String fromFile = url.getFile();
        this.copyFile(mode, fromFile, toFile);
    }

    @Override
    public URL getDecorateXsl() {
        return this.getResource("decorate.xsl");
    }

    @Override
    public int getGeneratedFiles() {
        return this.m_generatedFiles;
    }

    @Override
    public URL getManifestXsl() {
        return this.getResource("manifest.xsl");
    }

    @Override
    public URL getNormalizeXsl() {
        return this.getResource("normalize.xsl");
    }

    @Override
    public URL getTemplateXsl(String relativeFile) {
        return this.getResource(relativeFile);
    }

    @Override
    public void openStorage() throws IOException {
    }

    protected URL getResource(String name) {
        String path = this.m_resourceBasePath + "/" + name;
        URL url = this.getClass().getResource(path);
        if (url != null) {
            return url;
        }
        throw new RuntimeException("Can't find resource: " + path);
    }
}

