/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.template;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.codegen.template.XslTemplateManager;
import org.unidal.lookup.annotation.Named;

@Named(type=XslTemplateManager.class)
public class DefaultXslTemplateManager
implements XslTemplateManager,
LogEnabled {
    private Map<URL, Templates> m_cachedTemplates = new HashMap<URL, Templates>();
    private Map<URL, Long> m_lastModifiedDates = new HashMap<URL, Long>();
    Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public Templates getTemplates(URL style) {
        Templates templates = this.m_cachedTemplates.get(style);
        Long lastModifiedDate = this.m_lastModifiedDates.get(style);
        long lastModified = 0L;
        if ("file".equals(style.getProtocol())) {
            lastModified = new File(style.getFile()).lastModified();
        }
        if (templates == null || lastModifiedDate != lastModified) {
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setURIResolver(new URIResolver(){

                    @Override
                    public Source resolve(String href, String base) throws TransformerException {
                        try {
                            URL uri = new URL(new URL(base), href);
                            return new StreamSource(uri.openStream(), uri.toString());
                        }
                        catch (Exception e) {
                            DefaultXslTemplateManager.this.m_logger.warn("Can't result URI (" + base + "," + href + ")", (Throwable)e);
                            return null;
                        }
                    }
                });
                templates = factory.newTemplates(new StreamSource(style.openStream(), style.toString()));
                this.m_cachedTemplates.put(style, templates);
                this.m_lastModifiedDates.put(style, new Long(lastModified));
            }
            catch (Exception e) {
                throw new RuntimeException("Fail to open XSL template: " + style, e);
            }
        }
        return templates;
    }
}

