/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.transformer;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.unidal.codegen.template.XslTemplateManager;
import org.unidal.codegen.transformer.XslTransformer;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=XslTransformer.class)
public class DefaultXslTransformer
implements XslTransformer {
    @Inject
    private XslTemplateManager m_templateManager;

    private void setParameters(Transformer transformer, Map<String, String> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                transformer.setParameter(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public String transform(URL template, String source) throws TransformerException {
        return this.transform(template, source, null);
    }

    @Override
    public String transform(URL template, String source, Map<String, String> parameters) throws TransformerException {
        Transformer transformer = this.m_templateManager.getTemplates(template).newTransformer();
        StringReader reader = new StringReader(source);
        StringWriter buffer = new StringWriter(65536);
        this.setParameters(transformer, parameters);
        transformer.transform(new StreamSource(reader), new StreamResult(buffer));
        return buffer.toString();
    }
}

