/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.generator;

import java.net.URL;
import java.util.List;
import org.unidal.codegen.aggregator.XmlAggregator;
import org.unidal.codegen.generator.GenerateContext;
import org.unidal.codegen.generator.Generator;
import org.unidal.codegen.manifest.Manifest;
import org.unidal.codegen.manifest.ManifestParser;
import org.unidal.codegen.manifest.OperationMode;
import org.unidal.codegen.transformer.XslTransformer;
import org.unidal.lookup.annotation.Inject;

public class XslGenerator
implements Generator {
    @Inject
    private XmlAggregator m_xmlAggregator;
    @Inject
    private XslTransformer m_xslTransformer;
    @Inject
    private ManifestParser m_manifestParser;

    @Override
    public void generate(GenerateContext ctx) throws Exception {
        ctx.log(GenerateContext.LogLevel.INFO, "Aggregating ...");
        String aggregatedXml = this.m_xmlAggregator.aggregate(ctx.getManifestXml());
        ctx.log(GenerateContext.LogLevel.DEBUG, aggregatedXml);
        ctx.log(GenerateContext.LogLevel.INFO, "Normalizing ...");
        String normalizedXml = this.m_xslTransformer.transform(ctx.getNormalizeXsl(), aggregatedXml, ctx.getProperties());
        ctx.log(GenerateContext.LogLevel.DEBUG, normalizedXml);
        ctx.log(GenerateContext.LogLevel.INFO, "Decorating ...");
        String decoratedXml = this.m_xslTransformer.transform(ctx.getDecorateXsl(), normalizedXml, ctx.getProperties());
        ctx.log(GenerateContext.LogLevel.DEBUG, decoratedXml);
        ctx.log(GenerateContext.LogLevel.INFO, "Manifesting ...");
        String manifestXml = this.m_xslTransformer.transform(ctx.getManifestXsl(), decoratedXml, ctx.getProperties());
        List<Manifest> manifests = this.m_manifestParser.parse(manifestXml);
        ctx.log(GenerateContext.LogLevel.DEBUG, manifestXml);
        ctx.log(GenerateContext.LogLevel.INFO, "Generating ...");
        if (!manifests.isEmpty()) {
            ctx.openStorage();
            for (Manifest manifest : manifests) {
                OperationMode op = manifest.getOp();
                switch (op) {
                    case APPLY_TEMPLATE: {
                        URL templateXsl = ctx.getTemplateXsl(manifest.getTemplate());
                        String content = this.m_xslTransformer.transform(templateXsl, decoratedXml, manifest.getProperties());
                        ctx.addFileToStorage(manifest, content);
                        break;
                    }
                    case COPY_RESOURCES: {
                        ctx.copyFileToStorage(manifest);
                    }
                }
            }
            ctx.closeStorage();
        }
    }
}

