/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.codegen.meta;

import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.jdom.Content;
import org.jdom.Element;
import org.unidal.codegen.meta.XmlMeta;
import org.unidal.lookup.annotation.Named;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Named(type=XmlMeta.class)
public class DefaultXmlMeta
implements XmlMeta {
    private void addAttributes(Element element, Collection<AttributeEntry> attributes) {
        for (AttributeEntry e : attributes) {
            Element attribute = new Element("attribute");
            attribute.setAttribute("name", e.getName());
            attribute.setAttribute("value-type", e.getValueType());
            if (e.getFormat() != null) {
                attribute.setAttribute("format", e.getFormat());
            }
            element.addContent((Content)attribute);
        }
    }

    private void addElementRefs(Element parent, Collection<ElementEntry> elementRefs, String parentName) {
        for (ElementEntry e : elementRefs) {
            Element elementRef = new Element("element-ref");
            elementRef.setAttribute("name", e.getName());
            if (e.isList() || e.isList(parentName)) {
                elementRef.setAttribute("list", "true");
                if (e.getListName() != null) {
                    elementRef.setAttribute("list-name", e.getListName());
                }
            }
            parent.addContent((Content)elementRef);
        }
    }

    private void addElements(Element parent, Collection<ElementEntry> elements, String parentName) {
        for (ElementEntry e : elements) {
            Element element = new Element("element");
            element.setAttribute("name", e.getName());
            element.setAttribute("value-type", e.getValueType());
            if (e.getFormat() != null) {
                element.setAttribute("format", e.getFormat());
            }
            if (e.isList(parentName)) {
                element.setAttribute("list", "true");
            }
            if (e.isValue()) {
                element.setAttribute("value", "true");
            }
            parent.addContent((Content)element);
        }
    }

    @Override
    public Element getMeta(Reader reader) {
        XmlMetaParser parser = new XmlMetaParser();
        parser.parse(new InputSource(reader));
        parser.optimize();
        return this.toElement(parser.getEntries());
    }

    private Element toElement(List<ElementEntry> entries) {
        Element root = new Element("root");
        for (ElementEntry entry : entries) {
            String name = entry.getName();
            Element element = new Element("element");
            element.setAttribute("name", name);
            if (entry.isRoot()) {
                element.setAttribute("root", "true");
            }
            this.addAttributes(element, entry.getAttributes());
            this.addElements(element, entry.getElements(), name);
            this.addElementRefs(element, entry.getElementRefs(), name);
            root.addContent((Content)element);
        }
        return root;
    }

    static final class XmlMetaParser
    extends DefaultHandler {
        private Stack<ElementEntry> m_stack = new Stack();
        private Map<String, ElementEntry> m_elementMap = new LinkedHashMap<String, ElementEntry>();

        public XmlMetaParser() {
            this.m_stack.push(new ElementEntry());
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String str = new String(ch, start, length).trim();
            if (str.length() == 0) {
                return;
            }
            ElementEntry element = this.m_stack.peek();
            Collection<AttributeEntry> attributes = element.getAttributes();
            String[] typeAndFormat = Utils.guessValueTypeAndFormat(str);
            if (!attributes.isEmpty()) {
                ElementEntry text = new ElementEntry();
                text.setName("text");
                text.setValue(true);
                text.addValueType(typeAndFormat[0]);
                text.setFormat(typeAndFormat[1]);
                element.addElement(text);
            } else {
                if (!element.getElements().isEmpty() || !element.getElementRefs().isEmpty()) {
                    throw new RuntimeException("Text are not supported to entity with elements and element-refs.");
                }
                element.addValueType(typeAndFormat[0]);
                element.setFormat(typeAndFormat[1]);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            ElementEntry entry = this.m_stack.pop();
            for (ElementEntry e : entry.getElements()) {
                e.resetOccurs(entry.getName());
            }
            for (ElementEntry e : entry.getElementRefs()) {
                e.resetOccurs(entry.getName());
            }
        }

        public List<ElementEntry> getEntries() {
            ArrayList<ElementEntry> entries = new ArrayList<ElementEntry>();
            for (ElementEntry entry : this.m_elementMap.values()) {
                if (entry.isSimpleElement()) continue;
                entries.add(entry);
            }
            return entries;
        }

        public void optimize() {
            HashSet<ElementEntry> done = new HashSet<ElementEntry>();
            HashSet<String> trash = new HashSet<String>();
            this.optimize(this.m_stack.peek(), done, trash);
            for (String name : trash) {
                this.m_elementMap.remove(name);
            }
        }

        private void optimize(ElementEntry entry, Set<ElementEntry> done, Set<String> trash) {
            if (done.contains(entry)) {
                return;
            }
            done.add(entry);
            for (ElementEntry ref : entry.getElementRefs()) {
                ElementEntry first;
                String name = ref.getName();
                ElementEntry e = this.m_elementMap.get(name);
                if (e.getAttributes().isEmpty() && e.getElements().isEmpty() && e.getElementRefs().size() == 1 && (first = e.getElementRefs().iterator().next()).isList(name)) {
                    ref.setList(true);
                    ref.setName(first.getName());
                    ref.setListName(name);
                    trash.add(name);
                }
                this.optimize(e, done, trash);
            }
        }

        public void parse(InputSource source) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.newSAXParser().parse(source, (DefaultHandler)this);
            }
            catch (Exception e) {
                throw new RuntimeException("Error when parsing XML data. " + e.getMessage(), e);
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            String elementName = localName;
            ElementEntry parent = this.m_stack.peek();
            ElementEntry element = this.m_elementMap.get(elementName);
            if (element == null) {
                element = new ElementEntry();
                element.setName(elementName);
                this.m_elementMap.put(elementName, element);
            }
            int len = attributes.getLength();
            for (int i = 0; i < len; ++i) {
                AttributeEntry attribute = new AttributeEntry();
                String[] typeAndFormat = Utils.guessValueTypeAndFormat(attributes.getValue(i));
                attribute.setName(attributes.getQName(i));
                attribute.setValueType(typeAndFormat[0]);
                attribute.setFormat(typeAndFormat[1]);
                element.addAttribute(attribute);
            }
            if (parent.getName() == null) {
                element.setRoot(true);
            }
            element.increaseOccurs(parent.getName());
            parent.addElement(element);
            this.m_stack.push(element);
        }
    }

    public static final class Utils {
        private static SimpleDateFormat[] s_dateFormats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH)};

        public static String getValueType(Set<String> valueTypes) {
            int len = valueTypes.size();
            if (len == 1) {
                return valueTypes.iterator().next();
            }
            if (len == 2 && valueTypes.contains("int") && valueTypes.contains("double")) {
                return "double";
            }
            return "String";
        }

        public static String[] guessValueTypeAndFormat(String value) {
            String[] typeAndFormat = new String[2];
            String type = null;
            String format = null;
            if (value.equals("true") || value.equals("false")) {
                type = "boolean";
            } else {
                if (value.indexOf(46) >= 0) {
                    try {
                        Double.parseDouble(value);
                        type = "double";
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        Integer.parseInt(value);
                        type = "int";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (type == null) {
                    for (SimpleDateFormat dateFormat : s_dateFormats) {
                        try {
                            dateFormat.parse(value);
                            type = "Date";
                            format = dateFormat.toPattern();
                            break;
                        }
                        catch (ParseException parseException) {
                        }
                    }
                }
            }
            typeAndFormat[0] = type == null ? "String" : type;
            typeAndFormat[1] = format;
            return typeAndFormat;
        }
    }

    static final class Occurance {
        private int m_maxOccurs;
        private int m_occurs;

        Occurance() {
        }

        public int getMaxOccurs() {
            return this.m_maxOccurs;
        }

        public void increaseOccurs() {
            ++this.m_occurs;
            if (this.m_occurs > this.m_maxOccurs) {
                this.m_maxOccurs = this.m_occurs;
            }
        }

        public void resetOccurs() {
            this.m_occurs = 0;
        }
    }

    static final class ElementEntry {
        private String m_name;
        private Set<String> m_formats = new HashSet<String>();
        private Set<String> m_valueTypes = new HashSet<String>();
        private boolean m_list;
        private String m_listName;
        private boolean m_value;
        private boolean m_root;
        private Map<String, Occurance> m_occurs = new HashMap<String, Occurance>();
        private Map<String, AttributeEntry> m_attributes = new LinkedHashMap<String, AttributeEntry>();
        private Map<String, ElementEntry> m_elements = new LinkedHashMap<String, ElementEntry>();

        ElementEntry() {
        }

        public void addAttribute(AttributeEntry attribute) {
            AttributeEntry a = this.m_attributes.get(attribute.getName());
            if (a == null) {
                a = attribute;
                this.m_attributes.put(a.getName(), a);
            }
            a.setValueType(attribute.getValueType());
            a.setFormat(attribute.getFormat());
        }

        public void addElement(ElementEntry element) {
            ElementEntry e = this.m_elements.get(element.getName());
            if (e == null) {
                e = element;
                this.m_elements.put(e.getName(), e);
            }
            for (String valueType : element.getValueTypes()) {
                e.addValueType(valueType);
            }
            e.setFormat(element.getFormat());
            e.setValue(element.isValue());
        }

        public void addValueType(String valueType) {
            if (valueType != null && !this.m_valueTypes.contains(valueType)) {
                this.m_valueTypes.add(valueType);
            }
        }

        public Collection<AttributeEntry> getAttributes() {
            return this.m_attributes.values();
        }

        public Collection<ElementEntry> getElementRefs() {
            ArrayList<ElementEntry> elementRefs = new ArrayList<ElementEntry>();
            for (ElementEntry e : this.m_elements.values()) {
                if (e.isSimpleElement()) continue;
                elementRefs.add(e);
            }
            return elementRefs;
        }

        public Collection<ElementEntry> getElements() {
            ArrayList<ElementEntry> elements = new ArrayList<ElementEntry>();
            for (ElementEntry e : this.m_elements.values()) {
                if (!e.isSimpleElement()) continue;
                elements.add(e);
            }
            return elements;
        }

        public String getFormat() {
            if (this.m_formats.size() == 0 || this.m_valueTypes.size() > 1) {
                return null;
            }
            StringBuilder sb = new StringBuilder(64);
            boolean first = true;
            for (String format : this.m_formats) {
                if (!first) {
                    sb.append('|');
                }
                first = false;
                sb.append(format);
            }
            return sb.toString();
        }

        public String getListName() {
            return this.m_listName;
        }

        public String getName() {
            return this.m_name;
        }

        public String getValueType() {
            return Utils.getValueType(this.m_valueTypes);
        }

        Set<String> getValueTypes() {
            return this.m_valueTypes;
        }

        public void increaseOccurs(String parentName) {
            Occurance occur = this.m_occurs.get(parentName);
            if (occur == null) {
                occur = new Occurance();
                this.m_occurs.put(parentName, occur);
            }
            occur.increaseOccurs();
        }

        public boolean isList() {
            return this.m_list;
        }

        public boolean isList(String parentName) {
            Occurance occur = this.m_occurs.get(parentName);
            return occur != null && occur.getMaxOccurs() > 1;
        }

        public boolean isRoot() {
            return this.m_root;
        }

        public boolean isSimpleElement() {
            return this.m_attributes.isEmpty() && this.m_elements.isEmpty() && !this.m_list;
        }

        public boolean isValue() {
            return this.m_value;
        }

        public void removeElement(ElementEntry element) {
            this.m_elements.remove(element.getName());
        }

        public void resetOccurs(String parentName) {
            Occurance occur = this.m_occurs.get(parentName);
            if (occur != null) {
                occur.resetOccurs();
            }
        }

        public void setFormat(String format) {
            if (format != null && !this.m_formats.contains(format)) {
                this.m_formats.add(format);
            }
        }

        public void setList(boolean list) {
            this.m_list = list;
        }

        public void setListName(String listName) {
            this.m_listName = listName;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void setRoot(boolean root) {
            this.m_root = root;
        }

        public void setValue(boolean value) {
            this.m_value |= value;
        }

        public String toString() {
            return String.format("ElementEntry[%s, %s, %s, %s]", this.m_name, this.m_attributes, this.m_list ? "" : this.m_listName, this.m_elements);
        }
    }

    static final class AttributeEntry {
        private String m_name;
        private Set<String> m_formats = new HashSet<String>();
        private Set<String> m_valueTypes = new HashSet<String>();

        AttributeEntry() {
        }

        public String getFormat() {
            if (this.m_formats.size() == 0 || this.m_valueTypes.size() > 1) {
                return null;
            }
            StringBuilder sb = new StringBuilder(64);
            boolean first = true;
            for (String format : this.m_formats) {
                if (!first) {
                    sb.append('|');
                }
                first = false;
                sb.append(format);
            }
            return sb.toString();
        }

        public String getName() {
            return this.m_name;
        }

        public String getValueType() {
            return Utils.getValueType(this.m_valueTypes);
        }

        public void setFormat(String format) {
            if (format != null && !this.m_formats.contains(format)) {
                this.m_formats.add(format);
            }
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void setValueType(String valueType) {
            if (valueType != null && !this.m_valueTypes.contains(valueType)) {
                this.m_valueTypes.add(valueType);
            }
        }
    }
}

