<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="../../common.xsl"/>
<xsl:output method="html" indent="no" media-type="text/plain" encoding="utf-8"/>
<xsl:param name="package"/>
<xsl:param name="name"/>
<xsl:variable name="space" select="' '"/>
<xsl:variable name="empty" select="''"/>
<xsl:variable name="empty-line" select="'&#x0A;'"/>

<xsl:template match="/">
   <xsl:apply-templates select="/model/entity[@name = $name]"/>
</xsl:template>

<xsl:template match="entity">
   <xsl:value-of select="$empty"/>package <xsl:value-of select="$package"/>;<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty-line"/>
   <xsl:call-template name='import-list'/>
   <xsl:value-of select="$empty"/>public class <xsl:value-of select='@entity-class'/> extends BaseEntity<xsl:value-of select="$empty"/>
   <xsl:call-template name="generic-type">
      <xsl:with-param name="type" select="@entity-class"/>
   </xsl:call-template>
   <xsl:if test="@implements">
      <xsl:value-of select="$empty"/> implements <xsl:value-of select="@implements" disable-output-escaping="yes"/><xsl:value-of select="$empty"/>
   </xsl:if>
   <xsl:value-of select="$empty"/> {<xsl:value-of select="$empty-line"/>
   <xsl:call-template name="declare-field-variables"/>
   <xsl:call-template name="constructor"/>
   <xsl:call-template name="method-accept"/>
   <xsl:call-template name="method-add-children"/>
   <xsl:call-template name="method-equals"/>
   <xsl:call-template name="method-find-entity-refs"/>
   <xsl:call-template name="method-find-or-create-entity-refs"/>
   <!-- hack: for annotation only -->
   <xsl:call-template name="method-find-annotation"/>
   <xsl:call-template name="method-get-all-children-in-sequence"/>
   <xsl:call-template name="method-get-dynamic-attributes"/>
   <xsl:call-template name="method-get-dynamic-elements"/>
   <xsl:call-template name="method-get-fields"/>
   <xsl:call-template name="method-get-parent"/>
   <xsl:call-template name="method-has-text"/>
   <xsl:call-template name="method-hash-code"/>
   <xsl:call-template name="method-inc-fields"/>
   <!-- hack: for annotation only -->
   <xsl:call-template name="method-is-annotation-present"/>
   <xsl:call-template name="method-is-attributes"/>
   <xsl:if test="not(/model/@disable-merger='true')">
      <xsl:call-template name="method-merge-attributes"/>
   </xsl:if>
   <xsl:call-template name="method-remove-entity-refs"/>
   <xsl:call-template name="method-set-dynamic-attributes"/>
   <xsl:call-template name="method-set-dynamic-elements"/>
   <xsl:call-template name="method-set-fields"/>
   <xsl:call-template name="method-set-parent"/>
   <xsl:call-template name="snippets"/>
   <xsl:value-of select="$empty"/>}<xsl:value-of select="$empty-line"/>
</xsl:template>

<xsl:template name="import-list">
   <xsl:variable name="model-package" select="../@model-package"/>
   <xsl:if test="attribute[@key='true'] and not(/model/@disable-merger='true')">
      <xsl:for-each select="attribute[@key='true']">
         <xsl:value-of select="$empty"/>import static <xsl:value-of select="$model-package"/>.Constants.<xsl:value-of select='@upper-name'/>;<xsl:value-of select="$empty-line"/>
      </xsl:for-each>
      <xsl:value-of select="$empty"/>import static <xsl:value-of select="$model-package"/>.Constants.<xsl:value-of select='@upper-name'/>;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
   <xsl:if test="(attribute|element)[@list='true' or @set='true'] or entity-ref[@list='true' or @map='true'] or @dynamic-attributes='true' or any">
      <xsl:if test="element[@list='true'] or entity-ref[@list='true'] or any">
         <xsl:value-of select="$empty"/>import java.util.ArrayList;<xsl:value-of select="$empty-line"/>
      </xsl:if>
      <xsl:if test="entity-ref[(@set='true' or @list='true') and @thread-safe='true']">
         <xsl:value-of select="$empty"/>import java.util.Collections;<xsl:value-of select="$empty-line"/>
      </xsl:if>
      <xsl:if test="entity-ref[@map='true' and not(@thread-safe='true') and @keep-order='true'] or @dynamic-attributes='true'">
         <xsl:value-of select="$empty"/>import java.util.LinkedHashMap;<xsl:value-of select="$empty-line"/>
      </xsl:if>
      <xsl:if test="element[@set='true']">
         <xsl:value-of select="$empty"/>import java.util.LinkedHashSet;<xsl:value-of select="$empty-line"/>
      </xsl:if>
      <xsl:if test="(attribute|element)[@list='true'] or entity-ref[@list='true'] or any">
         <xsl:value-of select="$empty"/>import java.util.List;<xsl:value-of select="$empty-line"/>
      </xsl:if>
      <xsl:if test="entity-ref[@map='true' and @keep-order='false']">
         <xsl:value-of select="$empty"/>import java.util.HashMap;<xsl:value-of select="$empty-line"/>
      </xsl:if>
      <xsl:if test="entity-ref[@map='true'] or @dynamic-attributes='true'">
         <xsl:value-of select="$empty"/>import java.util.Map;<xsl:value-of select="$empty-line"/>
      </xsl:if>
      <xsl:if test="(attribute|element)[@set='true']">
         <xsl:value-of select="$empty"/>import java.util.Set;<xsl:value-of select="$empty-line"/>
      </xsl:if>
      <xsl:if test="entity-ref[@map='true' and @thread-safe='true']">
         <xsl:value-of select="$empty"/>import java.util.concurrent.ConcurrentHashMap;<xsl:value-of select="$empty-line"/>
      </xsl:if>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
   <xsl:value-of select="$empty"/>import <xsl:value-of select="$model-package"/>.BaseEntity;<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>import <xsl:value-of select="$model-package"/>.IVisitor;<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty-line"/>
</xsl:template>

<xsl:template name="declare-field-variables">
   <xsl:if test="@all-children-in-sequence='true'">
      <xsl:value-of select="$empty"/>   private <xsl:value-of select='@value-type-all-children-in-sequence' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-all-children-in-sequence'/> = new Array<xsl:value-of select='@value-type-all-children-in-sequence' disable-output-escaping="yes"/>();<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
   <xsl:for-each select="attribute | element | entity-ref">
      <xsl:variable name="prefix">
         <xsl:choose>
            <xsl:when test="@deprecated='true'">
               <xsl:value-of select="'   // DEPRECATED private '"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="'   private '"/>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:if test="@render='false'">transient </xsl:if>
      </xsl:variable>
      <xsl:choose>
         <xsl:when test="@map='true' and @thread-safe='true'">
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/> = new ConcurrentHashMap<xsl:value-of select='@value-type-generic' disable-output-escaping="yes"/>(<xsl:value-of select="@initial-capacity"/>);<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:when test="@map='true' and @keep-order='false'">
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/> = new HashMap<xsl:value-of select='@value-type-generic' disable-output-escaping="yes"/>(<xsl:value-of select="@initial-capacity"/>);<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:when test="@map='true'">
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/> = new LinkedHashMap<xsl:value-of select='@value-type-generic' disable-output-escaping="yes"/>(<xsl:value-of select="@initial-capacity"/>);<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:when test="@set='true' and name()='attribute'">
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/>;<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:when test="@set='true' and @thread-safe='true'">
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/> = Collections.synchronizedSet(new LinkedHashSet<xsl:value-of select='@value-type-generic' disable-output-escaping="yes"/>(<xsl:value-of select="@initial-capacity"/>));<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:when test="@set='true'">
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/> = new LinkedHashSet<xsl:value-of select='@value-type-generic' disable-output-escaping="yes"/>(<xsl:value-of select="@initial-capacity"/>);<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:when test="@list='true' and name()='attribute'">
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/>;<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:when test="@list='true' and @thread-safe='true'">
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/> = Collections.synchronizedList(new ArrayList<xsl:value-of select='@value-type-generic' disable-output-escaping="yes"/>(<xsl:value-of select="@initial-capacity"/>));<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:when test="@list='true'">
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/> = new ArrayList<xsl:value-of select='@value-type-generic' disable-output-escaping="yes"/>(<xsl:value-of select="@initial-capacity"/>);<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:when test="@default-value">
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/> = <xsl:call-template name="field-default-value"/>;<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:when test="name()='entity-ref' and @required='true'">
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/> = new <xsl:value-of select='@value-type' disable-output-escaping="yes"/>();<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$prefix"/><xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@field-name'/>;<xsl:value-of select="$empty-line"/>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="$empty-line"/>
   </xsl:for-each>
   <xsl:if test="@dynamic-attributes='true'">
      <xsl:value-of select="$empty"/>   private Map<xsl:value-of select="'&lt;String, String&gt;'" disable-output-escaping="yes"/> m_dynamicAttributes = new LinkedHashMap<xsl:value-of select="'&lt;String, String&gt;'" disable-output-escaping="yes"/>();<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
   <xsl:if test="any">
      <xsl:value-of select="$empty"/>   private <xsl:value-of select="any/@value-type" disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='any/@field-name'/> = new ArrayList<xsl:value-of select="any/@value-type-generic" disable-output-escaping="yes"/>();<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
   <xsl:if test="@parent='true'">
      <xsl:value-of select="$empty"/>   private transient <xsl:call-template name="parent-value-type"/> m_parent; <xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
</xsl:template>

<xsl:template name="constructor">
   <xsl:variable name="keys" select="attribute[@key='true'] | element[@key='true']"/>
   <xsl:if test="$keys">
      <xsl:value-of select="$empty"/>   public <xsl:value-of select='@entity-class'/>() {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
   <xsl:value-of select="$empty"/>   public <xsl:value-of select='@entity-class'/>(<xsl:value-of select="$empty"/>
   <xsl:for-each select="$keys">
   	  <xsl:sort select="@key-index"/>
	  
	  <xsl:if test="position()!=1">, </xsl:if>
      <xsl:value-of select='@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@param-name'/><xsl:value-of select="$empty"/>
   </xsl:for-each>
   <xsl:value-of select="$empty"/>) {<xsl:value-of select="$empty-line"/>
   <xsl:for-each select="attribute[@key='true'] | element[@key='true']">
      <xsl:choose>
         <xsl:when test="@primitive='true' or not(@default-value)">
            <xsl:value-of select="'      '"/><xsl:value-of select='@field-name'/> = <xsl:value-of select='@param-name'/>;<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="'      '"/>if (<xsl:value-of select='@param-name'/> != null) {<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="'         '"/><xsl:value-of select='@field-name'/> = <xsl:value-of select='@param-name'/>;<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="'      '"/>}<xsl:value-of select="$empty-line"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:for-each>
   <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty-line"/>
</xsl:template>

<xsl:template name="method-accept">
   <xsl:value-of select="$empty"/>   @Override<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>   public void accept(IVisitor visitor) {<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>      visitor.<xsl:value-of select="@visit-method"/>(this);<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty-line"/>
</xsl:template>

<xsl:template name="method-add-children">
   <xsl:variable name="entity" select="."/>
   <xsl:for-each select="entity-ref[@list='true' or @map='true'] | element[@list='true' or @set='true']">
      <xsl:sort select="@add-method"/>
      
      <xsl:value-of select="$empty"/>   public <xsl:value-of select='$entity/@entity-class'/><xsl:value-of select="$space"/><xsl:value-of select='@add-method'/>(<xsl:value-of select='@value-type-element' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@param-name-element'/>) {<xsl:value-of select="$empty-line"/>
      <xsl:if test="@parent='true'">
	     	<xsl:value-of select="'      '"/><xsl:value-of select='@param-name-element'/>.setParent(this);<xsl:value-of select="$empty-line"/>
      </xsl:if>
      <xsl:if test="$entity/@all-children-in-sequence='true'">
	     	<xsl:value-of select="'      '"/><xsl:value-of select='$entity/@field-all-children-in-sequence'/>.add(<xsl:value-of select='@param-name-element'/>);<xsl:value-of select="$empty-line"/>
      </xsl:if>
      <xsl:choose>
         <xsl:when test="@map='true'">
            <xsl:variable name="name" select="@name"/>
   			<xsl:variable name="keys" select="//entity[@name=$name]/node()[name()='attribute' or name()='element'][@key]"/>
   			
   			<xsl:choose>
   			   <xsl:when test="$keys[2]">
	   	     	  <xsl:value-of select="'      '"/><xsl:value-of select='@field-name'/>.put(<xsl:value-of select='@param-name-element'/>, <xsl:value-of select='@param-name-element'/>);<xsl:value-of select="$empty-line"/>
   			   </xsl:when>
   			   <xsl:otherwise>
	   	     	  <xsl:value-of select="'      '"/><xsl:value-of select='@field-name'/>.put(<xsl:value-of select='@param-name-element'/>.<xsl:value-of select="$keys/@get-method"/>(), <xsl:value-of select='@param-name-element'/>);<xsl:value-of select="$empty-line"/>
   			   </xsl:otherwise>
   			</xsl:choose>
         </xsl:when>
         <xsl:when test="@set='true'">
   	     	<xsl:value-of select="'      '"/><xsl:value-of select='@field-name'/>.add(<xsl:value-of select='@param-name-element'/>);<xsl:value-of select="$empty-line"/>
   		 </xsl:when>
         <xsl:when test="@list='true'">
   	     	<xsl:value-of select="'      '"/><xsl:value-of select='@field-name'/>.add(<xsl:value-of select='@param-name-element'/>);<xsl:value-of select="$empty-line"/>
   		 </xsl:when>
         <xsl:otherwise>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="$empty"/>      return this;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:for-each>
</xsl:template>

<xsl:template name="method-equals">
   <xsl:variable name="entity" select="." />
   <xsl:variable name="keys" select="(attribute|element)[@key='true']" />
   <xsl:value-of select="$empty"/>   @Override<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>   public boolean equals(Object obj) {<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>      if (obj instanceof <xsl:value-of select="@entity-class"/>) {<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="'         '"/><xsl:value-of select="@entity-class"/> _o = (<xsl:value-of select="@entity-class"/>) obj;<xsl:value-of select="$empty-line"/>
   <xsl:choose>
      <xsl:when test="not($keys)">
         <xsl:value-of select="$empty-line"/>
         <xsl:for-each select="(attribute|element|entity-ref)[not(@render='false')]">
            <xsl:choose>
               <xsl:when test="@primitive='true'">
                  <xsl:value-of select="$empty"/>         if (<xsl:value-of select="@get-method"/>() != _o.<xsl:value-of select="@get-method"/>()) {<xsl:value-of select="$empty-line"/>
                  <xsl:value-of select="$empty"/>            return false;<xsl:value-of select="$empty-line"/>
                  <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
               </xsl:when>
               <xsl:otherwise>
                  <xsl:value-of select="$empty"/>         if (!equals(<xsl:value-of select="@get-method"/>(), _o.<xsl:value-of select="@get-method"/>())) {<xsl:value-of select="$empty-line"/>
                  <xsl:value-of select="$empty"/>            return false;<xsl:value-of select="$empty-line"/>
                  <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
               </xsl:otherwise>
            </xsl:choose>
	        <xsl:value-of select="$empty-line"/>
         </xsl:for-each>
         <xsl:if test="@dynamic-attributes='true'">
            <xsl:value-of select="$empty"/>         if (!m_dynamicAttributes.equals(_o.getDynamicAttributes())) {<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="$empty"/>            return false;<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
         </xsl:if>
         <xsl:for-each select="any[not(@render='false')]">
            <xsl:value-of select="$empty"/>         if (!<xsl:value-of select="@get-method"/>().equals(_o.<xsl:value-of select="@get-method"/>())) {<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="$empty"/>            return false;<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
         </xsl:for-each>
         <xsl:value-of select="$empty-line"/>
         <xsl:value-of select="$empty"/>         return true;<xsl:value-of select="$empty-line"/>
      </xsl:when>
      <xsl:otherwise>
         <xsl:value-of select="$empty-line"/>
      	 <xsl:for-each select="$keys">
      	 	 <xsl:sort select="@key-index"/>
      	 	 
      	 	 <xsl:choose>
		       <xsl:when test="@primitive='true'">
		         <xsl:value-of select="$empty"/>         if (<xsl:value-of select="@get-method"/>() != _o.<xsl:value-of select="@get-method"/>()) {<xsl:value-of select="$empty-line"/>
		         <xsl:value-of select="$empty"/>            return false;<xsl:value-of select="$empty-line"/>
		         <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
		         <xsl:value-of select="$empty-line"/>
		       </xsl:when>
		       <xsl:otherwise>
		         <xsl:value-of select="$empty"/>         if (!equals(<xsl:value-of select="@get-method"/>(), _o.<xsl:value-of select="@get-method"/>())) {<xsl:value-of select="$empty-line"/>
		         <xsl:value-of select="$empty"/>            return false;<xsl:value-of select="$empty-line"/>
		         <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
		         <xsl:value-of select="$empty-line"/>
		       </xsl:otherwise>
      	 	 </xsl:choose>
      	 </xsl:for-each>
	     <xsl:value-of select="$empty"/>         return true;<xsl:value-of select="$empty-line"/>
      </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>      return false;<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty-line"/>
</xsl:template>

<xsl:template name="method-find-entity-refs">
   <xsl:for-each select="entity-ref[@list='true' or @map='true']">
      <xsl:sort select="@find-method"/>
      
      <xsl:variable name="name" select="@name"/>
      <xsl:variable name="entity" select="//entity[@name=$name]"/>
      <xsl:variable name="keys" select="($entity/attribute | $entity/element)[@key='true']"/>
      <xsl:if test="$keys">
         <xsl:value-of select="$empty"/>   public <xsl:value-of select='@value-type-element' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@find-method'/>(<xsl:value-of select="$empty"/>
         <xsl:for-each select="$keys">
         	<xsl:sort select="@key-index"/>

            <xsl:if test="position()!=1">, </xsl:if>
            <xsl:value-of select="@value-type" disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select="@param-name"/>
         </xsl:for-each>
         <xsl:value-of select="$empty"/>) {<xsl:value-of select="$empty-line"/>
         <xsl:choose>
            <xsl:when test="@map='true'">
               <xsl:choose>
               	  <xsl:when test="$keys[2]">
		      	     <xsl:value-of select="$empty"/>      return <xsl:value-of select='@field-name'/>.get(new <xsl:value-of select='@value-type-element' disable-output-escaping="yes"/>(<xsl:value-of select="$empty"/>
		      	     <xsl:for-each select="$keys">
		      	     	<xsl:sort select="@key-index"/>
		      	     	
		      	     	<xsl:if test="position()!=1">, </xsl:if>
		      	     	<xsl:value-of select="@param-name"/>
		      	     </xsl:for-each>
		      	     <xsl:value-of select="$empty"/>));<xsl:value-of select="$empty-line"/>
               	  </xsl:when>
               	  <xsl:otherwise>
		      	     <xsl:value-of select="$empty"/>      return <xsl:value-of select='@field-name'/>.get(<xsl:value-of select="$keys[1]/@param-name"/>);<xsl:value-of select="$empty-line"/>
               	  </xsl:otherwise>
               </xsl:choose>
            </xsl:when>
            <xsl:when test="@list='true'">
               <xsl:value-of select="$empty"/>      for (<xsl:value-of select='@value-type-element'/><xsl:value-of select="$space"/><xsl:value-of select='@param-name-element'/> : <xsl:value-of select='@field-name'/>) {<xsl:value-of select="$empty-line"/>
               <xsl:variable name="current" select="." />
               <xsl:for-each select="$keys">
               	  <xsl:sort select="@key-index"/>

                  <xsl:choose>
                     <xsl:when test="@primitive='true'">
                        <xsl:value-of select="$empty"/>         if (<xsl:value-of select='$current/@param-name-element'/>.<xsl:value-of select="@get-method"/>() != <xsl:value-of select="@param-name"/>) {<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>            continue;<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:value-of select="$empty"/>         if (!equals(<xsl:value-of select='$current/@param-name-element'/>.<xsl:value-of select="@get-method"/>(), <xsl:value-of select="@param-name"/>)) {<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>            continue;<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
                     </xsl:otherwise>
                  </xsl:choose>
                  <xsl:value-of select="$empty-line"/>
                  <xsl:if test="position()=last()">
                     <xsl:value-of select="$empty"/>         return <xsl:value-of select='$current/@param-name-element'/>;<xsl:value-of select="$empty-line"/>
                  </xsl:if>
               </xsl:for-each>
               <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty"/>      return null;<xsl:value-of select="$empty-line"/>
   		    </xsl:when>
         </xsl:choose>
         <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
         <xsl:value-of select="$empty-line"/>
      </xsl:if>
   </xsl:for-each>
</xsl:template>

<xsl:template name="method-find-or-create-entity-refs">
   <xsl:for-each select="entity-ref[@find-or-create-method]">
      <xsl:sort select="@find-or-create-method"/>
      
      <xsl:variable name="name" select="@name"/>
      <xsl:variable name="entity" select="//entity[@name=$name]"/>
      <xsl:variable name="keys" select="($entity/attribute | $entity/element)[@key='true']"/>
      <xsl:if test="$keys">
         <xsl:value-of select="$empty"/>   public <xsl:value-of select='@value-type-element' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@find-or-create-method'/>(<xsl:value-of select="$empty"/>
         <xsl:for-each select="$keys">
            <xsl:sort select="@key-index"/>
            
            <xsl:if test="position() != 1">, </xsl:if>
            <xsl:value-of select="@value-type" disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select="@param-name"/>
         </xsl:for-each>
         <xsl:value-of select="$empty"/>) {<xsl:value-of select="$empty-line"/>
         <xsl:variable name="key" select="$keys[1]"/>
         <xsl:choose>
            <xsl:when test="@map='true'">
               <xsl:choose>
               	  <xsl:when test="$keys[2]">
		             <xsl:value-of select="$empty"/>      <xsl:value-of select="'      '"/><xsl:value-of select='@value-type-element' disable-output-escaping="yes"/> _key = new <xsl:value-of select='@value-type-element' disable-output-escaping="yes"/>(<xsl:value-of select="$empty"/>
			         <xsl:for-each select="$keys">
			            <xsl:sort select="@key-index"/>
			            
			            <xsl:if test="position() != 1">, </xsl:if>
			            <xsl:value-of select="@param-name"/>
			         </xsl:for-each>
		             <xsl:value-of select="$empty"/>);<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>      <xsl:value-of select="'      '"/><xsl:value-of select='@value-type-element' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select="@local-name-element"/> = <xsl:value-of select='@field-name'/>.get(_key);<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>      if (<xsl:value-of select="@local-name-element"/> == null) {<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>         synchronized (<xsl:value-of select="@field-name"/>) {<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>            <xsl:value-of select="'            '"/><xsl:value-of select="@local-name-element"/> = <xsl:value-of select='@field-name'/>.get(_key);<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>            if (<xsl:value-of select="@local-name-element"/> == null) {<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>               <xsl:value-of select="'               '"/><xsl:value-of select="@local-name-element"/> = _key;<xsl:value-of select="$empty-line"/>
	                 <xsl:value-of select="$empty"/>               <xsl:value-of select="'               '"/><xsl:value-of select='@field-name'/>.put(_key, <xsl:value-of select="@local-name-element"/>);<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>            }<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>      return <xsl:value-of select="@local-name-element"/>;<xsl:value-of select="$empty-line"/>
               	  </xsl:when>
               	  <xsl:otherwise>
		             <xsl:value-of select="$empty"/>      <xsl:value-of select="'      '"/><xsl:value-of select='@value-type-element' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select="@local-name-element"/> = <xsl:value-of select='@field-name'/>.get(<xsl:value-of select="$key/@param-name"/>);<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>      if (<xsl:value-of select="@local-name-element"/> == null) {<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>         synchronized (<xsl:value-of select="@field-name"/>) {<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>            <xsl:value-of select="'            '"/><xsl:value-of select="@local-name-element"/> = <xsl:value-of select='@field-name'/>.get(<xsl:value-of select="$key/@param-name"/>);<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>            if (<xsl:value-of select="@local-name-element"/> == null) {<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>               <xsl:value-of select="'               '"/><xsl:value-of select="@local-name-element"/> = new <xsl:value-of select='@value-type-element' disable-output-escaping="yes"/>(<xsl:value-of select="$key/@param-name"/>);<xsl:value-of select="$empty-line"/>
	                 <xsl:value-of select="$empty"/>               <xsl:value-of select="'               '"/><xsl:value-of select='@field-name'/>.put(<xsl:value-of select="$key/@param-name"/>, <xsl:value-of select="@local-name-element"/>);<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>            }<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty-line"/>
		             <xsl:value-of select="$empty"/>      return <xsl:value-of select="@local-name-element"/>;<xsl:value-of select="$empty-line"/>
               	  </xsl:otherwise>
               </xsl:choose>
            </xsl:when>
            <xsl:when test="@list='true'">
               <xsl:value-of select="$empty"/>      synchronized (<xsl:value-of select="@field-name"/>) {<xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty"/>         for (<xsl:value-of select='@value-type-element'/><xsl:value-of select="$space"/><xsl:value-of select='@param-name-element'/> : <xsl:value-of select='@field-name'/>) {<xsl:value-of select="$empty-line"/>
               <xsl:variable name="current" select="." />
               <xsl:for-each select="$keys">
                  <xsl:sort select="@key-index"/>
                  
                  <xsl:choose>
                     <xsl:when test="@primitive='true'">
                        <xsl:value-of select="$empty"/>            if (<xsl:value-of select='$current/@param-name-element'/>.<xsl:value-of select="@get-method"/>() != <xsl:value-of select="@param-name"/>) {<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>               continue;<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>            }<xsl:value-of select="$empty-line"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:value-of select="$empty"/>            if (!equals(<xsl:value-of select='$current/@param-name-element'/>.<xsl:value-of select="@get-method"/>(), <xsl:value-of select="@param-name"/>)) {<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>               continue;<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>            }<xsl:value-of select="$empty-line"/>
                     </xsl:otherwise>
                  </xsl:choose>
                  <xsl:value-of select="$empty-line"/>
               </xsl:for-each>
               <xsl:value-of select="$empty"/>            return <xsl:value-of select='$current/@param-name-element'/>;<xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty"/>         <xsl:value-of select="'         '"/><xsl:value-of select='@value-type-element' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='$current/@param-name-element'/> = new <xsl:value-of select='@value-type-element' disable-output-escaping="yes"/>(<xsl:value-of select="$empty"/>
               <xsl:choose>
				  <xsl:when test="$keys[2]">
			         <xsl:for-each select="$keys">
			            <xsl:sort select="@key-index"/>
			            
			            <xsl:if test="position() != 1">, </xsl:if>
			            <xsl:value-of select="@param-name"/>
			         </xsl:for-each>
				  </xsl:when>
				  <xsl:otherwise><xsl:value-of select='$key/@param-name'/></xsl:otherwise>
               </xsl:choose>
               <xsl:value-of select="$empty"/>);<xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty"/>         <xsl:value-of select="'         '"/><xsl:value-of select='@field-name'/>.add(<xsl:value-of select='$current/@param-name-element'/>);<xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty"/>         return <xsl:value-of select='$current/@param-name-element'/>;<xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
             </xsl:when>
         </xsl:choose>
         <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
         <xsl:value-of select="$empty-line"/>
      </xsl:if>      
   </xsl:for-each>
</xsl:template>

<xsl:template name="method-find-annotation">
   <xsl:if test="element[@is-annotation='true']">
      <xsl:value-of select="$empty"/>   @SuppressWarnings("unchecked")<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   public <xsl:call-template name="generic-type"><xsl:with-param name="type" select="'T extends java.lang.annotation.Annotation'"/></xsl:call-template> T findAnnotation(Class<xsl:call-template name="generic-type"><xsl:with-param name="type" select="'T'"/></xsl:call-template> clazz) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      for (java.lang.annotation.Annotation annotation : m_annotations) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>         if (annotation.annotationType() == clazz) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>            return (T) annotation;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return null;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
</xsl:template>

<xsl:template name="method-get-all-children-in-sequence">
   <xsl:if test="@all-children-in-sequence='true'">
      <xsl:value-of select="$empty"/>   public <xsl:value-of select="@value-type-all-children-in-sequence" disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@method-get-all-children-in-sequence'/>() {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return <xsl:value-of select='@field-all-children-in-sequence'/>;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
</xsl:template>

<xsl:template name="method-get-dynamic-attributes">
   <xsl:if test="@dynamic-attributes='true'">
      <xsl:value-of select="$empty"/>   public String getDynamicAttribute(String name) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return m_dynamicAttributes.get(name);<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   public Map<xsl:value-of select="'&lt;String, String&gt;'" disable-output-escaping="yes"/> getDynamicAttributes() {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return m_dynamicAttributes;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
</xsl:template>

<xsl:template name="method-get-dynamic-elements">
   <xsl:if test="any">
      <xsl:value-of select="$empty"/>   public <xsl:value-of select='any/@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='any/@get-method'/>() {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return <xsl:value-of select='any/@field-name'/>;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
</xsl:template>

<xsl:template name="method-get-fields">
   <xsl:for-each select="attribute[not(@deprecated='true')][not(@method-get='false')] | element[not(@method-get='false')] | entity-ref">
      <xsl:sort select="@get-method"/>
      
      <xsl:value-of select="$empty"/>   public <xsl:value-of select="@value-type" disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='@get-method'/>() {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return <xsl:value-of select='@field-name'/>;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:for-each>
</xsl:template>

<xsl:template name="method-get-parent">
   <xsl:if test="@parent='true'">
      <xsl:variable name="parent-value-type"><xsl:call-template name="parent-value-type"/></xsl:variable>
      <xsl:choose>
         <xsl:when test="$parent-value-type='Object'">
            <xsl:value-of select="$empty"/>   @SuppressWarnings("unchecked")<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="$empty"/>   public <xsl:value-of select="'&lt;T&gt;'" disable-output-escaping="yes"/> T parent() {<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="$empty"/>      return (T) m_parent;<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$empty"/>   public <xsl:value-of select="$parent-value-type"/><xsl:value-of select="$space"/>parent() {<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="$empty"/>      return m_parent;<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
            <xsl:value-of select="$empty-line"/>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:if>
</xsl:template>

<xsl:template name="method-has-text">
   <xsl:for-each select="attribute[@text='true']">
      <xsl:value-of select="$empty"/>   public boolean hasText() {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return <xsl:value-of select='@field-name'/> != null;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:for-each>
</xsl:template>

<xsl:template name="method-hash-code">
   <xsl:variable name="entity" select="." />
   <xsl:variable name="keys" select="(attribute|element)[@key='true']" />
   <xsl:value-of select="$empty"/>   @Override<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>   public int hashCode() {<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>      int hash = 0;<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty-line"/>
   <xsl:choose>
      <xsl:when test="not($keys)">
         <xsl:for-each select="(attribute|element|entity-ref)[not(@render='false')]">
             <xsl:call-template name="hash-line"/>
         </xsl:for-each>
         <xsl:if test="@dynamic-attributes='true'">
            <xsl:value-of select="$empty"/>      hash = hash * 31 + m_dynamicAttributes.hashCode();<xsl:value-of select="$empty-line"/>
         </xsl:if>
      </xsl:when>
      <xsl:otherwise>
      	  <xsl:for-each select="$keys">
      	  	 <xsl:sort select="@key-index"/>
      	  	 
	         <xsl:call-template name="hash-line" />
      	  </xsl:for-each>
         </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>      return hash;<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty-line"/>
</xsl:template>

<xsl:template name="method-is-annotation-present">
   <xsl:if test="element[@is-annotation='true']">
      <xsl:value-of select="$empty"/>   public boolean isAnnotationPresent(Class<xsl:call-template name="generic-type"><xsl:with-param name="type" select="'? extends java.lang.annotation.Annotation'"/></xsl:call-template> clazz) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return findAnnotation(clazz) != null;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
</xsl:template>

<xsl:template name="method-is-attributes">
   <xsl:for-each select="(attribute | element)[@value-type='boolean' or @value-type='Boolean']">
      <xsl:sort select="@is-method"/>
      
      <xsl:value-of select="$empty"/>   public boolean <xsl:value-of select='@is-method'/>() {<xsl:value-of select="$empty-line"/>
      <xsl:choose>
         <xsl:when test="@value-type='boolean'">
            <xsl:value-of select="$empty"/>      return <xsl:value-of select='@field-name'/>;<xsl:value-of select="$empty-line"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="$empty"/>      return <xsl:value-of select='@field-name'/> != null <xsl:value-of select="'&amp;&amp; '" disable-output-escaping="yes"/><xsl:value-of select='@field-name'/>.booleanValue();<xsl:value-of select="$empty-line"/>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:for-each>
</xsl:template>

<xsl:template name="method-merge-attributes">
   <xsl:variable name="entity" select="." />
   <xsl:value-of select="$empty"/>   @Override<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty"/>   public void mergeAttributes(<xsl:value-of select='$entity/@entity-class'/> other) {<xsl:value-of select="$empty-line"/>

   <xsl:variable name="keys" select="$entity/attribute[@key='true']"/>
   <xsl:if test="$keys">
      <xsl:for-each select="$keys">
      	 <xsl:sort select="@key-index"/>

         <xsl:value-of select="$empty"/>      assertAttributeEquals(other, <xsl:value-of select='$entity/@upper-name'/>
         <xsl:value-of select="$empty"/>, <xsl:value-of select='@upper-name'/>, <xsl:value-of select='@field-name'/>, other.<xsl:value-of select='@get-method'/>()<xsl:value-of select="$empty"/>
      	 <xsl:value-of select="$empty"/>);<xsl:value-of select="$empty-line"/>
      </xsl:for-each>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>

   <xsl:if test="@dynamic-attributes='true'">
      <xsl:value-of select="$empty"/>      for (Map.Entry<xsl:value-of select="'&lt;String, String&gt;'" disable-output-escaping="yes"/> e : other.getDynamicAttributes().entrySet()) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>         m_dynamicAttributes.put(e.getKey(), e.getValue());<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>

   <xsl:for-each select="$entity/attribute[not(@key='true')][not(@deprecated='true')]">
      <xsl:choose>
      	<!-- TODO @default-value -->
      	<xsl:when test="not(@primitive='true') or (@type='array' or @type='list' or @type='set')">
	      <xsl:value-of select="$empty"/>      if (other.<xsl:value-of select='@get-method'/>() != null) {<xsl:value-of select="$empty-line"/>
	      <xsl:value-of select="$empty"/><xsl:value-of select="'         '"/><xsl:value-of select='@field-name'/> = other.<xsl:value-of select='@get-method'/>();<xsl:value-of select="$empty-line"/>
	      <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
      	</xsl:when>
      	<xsl:otherwise>
	      <xsl:value-of select="$empty"/><xsl:value-of select="'      '"/><xsl:value-of select='@field-name'/> = other.<xsl:value-of select='@get-method'/>();<xsl:value-of select="$empty-line"/>
      	</xsl:otherwise>
      </xsl:choose>
      <xsl:if test="position()!=last()">
         <xsl:value-of select="$empty-line"/>
      </xsl:if>
   </xsl:for-each>
   <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
   <xsl:value-of select="$empty-line"/>
</xsl:template>

<xsl:template name="method-remove-entity-refs">
   <xsl:for-each select="entity-ref[@list='true' or @map='true']">
      <xsl:sort select="@remove-method"/>
      
      <xsl:variable name="name" select="@name"/>
      <xsl:variable name="entity" select="//entity[@name=$name]"/>
      <xsl:variable name="keys" select="($entity/attribute | $entity/element)[@key='true']"/>
      <xsl:if test="$keys">
         <xsl:value-of select="$empty"/>   public <xsl:value-of select='@value-type-element'/><xsl:value-of select='$space'/><xsl:value-of select='@remove-method'/>(<xsl:value-of select="$empty"/>
         <xsl:for-each select="$keys">
         	<xsl:sort select="@key-index"/>

            <xsl:if test="position()!=1">, </xsl:if>
            <xsl:value-of select="@value-type" disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select="@param-name"/>
         </xsl:for-each>
         <xsl:value-of select="$empty"/>) {<xsl:value-of select="$empty-line"/>
         <xsl:choose>
            <xsl:when test="@map='true'">
               <xsl:choose>
                  <xsl:when test="$keys[2]">
		      	     <xsl:value-of select="$empty"/>      return <xsl:value-of select='@field-name'/>.remove(new <xsl:value-of select='@value-type-element' disable-output-escaping="yes"/>(<xsl:value-of select="$empty"/>
		      	     <xsl:for-each select="$keys">
		      	     	<xsl:sort select="@key-index"/>
		      	     	
		      	     	<xsl:if test="position()!=1">, </xsl:if>
		      	     	<xsl:value-of select="@param-name"/>
		      	     </xsl:for-each>
		      	     <xsl:value-of select="$empty"/>));<xsl:value-of select="$empty-line"/>
                  </xsl:when>
                  <xsl:otherwise>
               	     <xsl:value-of select="$empty"/>      return <xsl:value-of select='@field-name'/>.remove(<xsl:value-of select="$keys[1]/@param-name"/>);<xsl:value-of select="$empty-line"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:when>
            <xsl:when test="@list='true'">
               <xsl:value-of select="$empty"/>      int len = <xsl:value-of select='@field-name'/>.size();<xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty"/>      for (int i = 0; i <xsl:value-of select="'&lt;'" disable-output-escaping="yes"/> len; i++) {<xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty"/>         <xsl:value-of select="'         '"/><xsl:value-of select='@value-type-element'/><xsl:value-of select="$space"/><xsl:value-of select='@param-name-element'/> = <xsl:value-of select='@field-name'/>.get(i);<xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty-line"/>
               <xsl:variable name="current" select="." />
               <xsl:for-each select="$keys">
               	  <xsl:sort select="@key-index"/>
               	  
                  <xsl:choose>
                     <xsl:when test="@primitive='true'">
                        <xsl:value-of select="$empty"/>         if (<xsl:value-of select='$current/@param-name-element'/>.<xsl:value-of select="@get-method"/>() != <xsl:value-of select="@param-name"/>) {<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>            continue;<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
                     </xsl:when>
                     <xsl:otherwise>
                        <xsl:value-of select="$empty"/>         if (!equals(<xsl:value-of select='$current/@param-name-element'/>.<xsl:value-of select="@get-method"/>(), <xsl:value-of select="@param-name"/>)) {<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>            continue;<xsl:value-of select="$empty-line"/>
                        <xsl:value-of select="$empty"/>         }<xsl:value-of select="$empty-line"/>
                     </xsl:otherwise>
                  </xsl:choose>
                  <xsl:value-of select="$empty-line"/>
               </xsl:for-each>
               <xsl:value-of select="$empty"/>         return <xsl:value-of select='@field-name'/>.remove(i);<xsl:value-of select="$empty-line"/>
               <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
	           <xsl:value-of select="$empty-line"/>
	           <xsl:value-of select="$empty"/>      return null;<xsl:value-of select="$empty-line"/>
            </xsl:when>
         </xsl:choose>
         <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
         <xsl:value-of select="$empty-line"/>
      </xsl:if>
   </xsl:for-each>
</xsl:template>

<xsl:template name="method-set-dynamic-attributes">
   <xsl:if test="@dynamic-attributes='true'">
      <xsl:value-of select="$empty"/>   public void setDynamicAttribute(String name, String value) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      m_dynamicAttributes.put(name, value);<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
</xsl:template>

<xsl:template name="method-set-dynamic-elements">
   <xsl:if test="any">
      <xsl:value-of select="$empty"/>   public void <xsl:value-of select='any/@set-method'/>(<xsl:value-of select='any/@value-type' disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select='any/@param-name'/>) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      <xsl:value-of select="'      '"/><xsl:value-of select='any/@field-name'/> = <xsl:value-of select='any/@param-name'/>;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
</xsl:template>

<xsl:template name="method-set-fields">
   <xsl:variable name="entity" select="." />
   <xsl:for-each select="attribute[not(@readonly='true' and not(@key='true'))][not(@deprecated='true')] | element[not(@readonly='true' and not(@key='true') or @list='true' or @set='true')] | entity-ref[not(@list='true' or @map='true')]">
      <xsl:sort select="@set-method"/>
      
      <xsl:value-of select="$empty"/>   public <xsl:value-of select='$entity/@entity-class'/><xsl:value-of select='$space'/><xsl:value-of select='@set-method'/>(<xsl:value-of select="@value-type" disable-output-escaping="yes"/><xsl:value-of select="$space"/><xsl:value-of select="@param-name"/>) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      <xsl:value-of select="'      '"/><xsl:value-of select="@field-name"/> = <xsl:value-of select="@param-name"/>;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return this;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:for-each>
</xsl:template>

<xsl:template name="method-set-parent">
   <xsl:if test="@parent='true'">
      <xsl:value-of select="$empty"/>   public <xsl:value-of select="@class-name" disable-output-escaping="yes"/><xsl:value-of select="$space"/>setParent(<xsl:call-template name="parent-value-type"/> parent) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      m_parent = parent;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return this;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:if>
</xsl:template>


<xsl:template name="method-inc-fields">
   <xsl:variable name="entity" select="." />
   <xsl:for-each select="(attribute | element)[@inc-method]">
      <xsl:sort select="@inc-method"/>
      
      <xsl:value-of select="$empty"/>   public <xsl:value-of select='$entity/@entity-class'/><xsl:value-of select='$space'/><xsl:value-of select='@inc-method'/>() {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      <xsl:value-of select="'      '"/><xsl:value-of select="@field-name"/>++;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return this;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
      
      <xsl:value-of select="$empty"/>   public <xsl:value-of select='$entity/@entity-class'/><xsl:value-of select='$space'/><xsl:value-of select='@inc-method'/>(<xsl:value-of select="@value-type"/><xsl:value-of select="$space"/><xsl:value-of select="@param-name"/>) {<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      <xsl:value-of select="'      '"/><xsl:value-of select="@field-name"/> += <xsl:value-of select="@param-name"/>;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>      return this;<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty"/>   }<xsl:value-of select="$empty-line"/>
      <xsl:value-of select="$empty-line"/>
   </xsl:for-each>
</xsl:template>

<xsl:template name="field-default-value">
	<xsl:choose>
      <xsl:when test="@value-type = 'String'">"<xsl:value-of select="@default-value" disable-output-escaping="yes"/>"</xsl:when>
      <xsl:when test="@value-type = 'Time'"><xsl:value-of select="@default-value"/>L</xsl:when>
      <xsl:when test="@value-type = 'boolean'"><xsl:value-of select="@default-value"/></xsl:when>
      <xsl:when test="@value-type = 'Boolean'"><xsl:value-of select="@default-value"/></xsl:when>
      <xsl:when test="@value-type = 'byte'">(byte)<xsl:value-of select="@default-value"/></xsl:when>
      <xsl:when test="@value-type = 'Byte'">(byte)<xsl:value-of select="@default-value"/></xsl:when>
      <xsl:when test="@value-type = 'char'">'<xsl:value-of select="@default-value"/>'</xsl:when>
      <xsl:when test="@value-type = 'Character'">'<xsl:value-of select="@default-value"/>'</xsl:when>
      <xsl:when test="@value-type = 'short'">(short)<xsl:value-of select="@default-value"/></xsl:when>
      <xsl:when test="@value-type = 'Short'">(short)<xsl:value-of select="@default-value"/></xsl:when>
      <xsl:when test="@value-type = 'int'"><xsl:value-of select="@default-value"/></xsl:when>
      <xsl:when test="@value-type = 'Integer'"><xsl:value-of select="@default-value"/></xsl:when>
      <xsl:when test="@value-type = 'long'"><xsl:value-of select="@default-value"/>L</xsl:when>
      <xsl:when test="@value-type = 'Long'"><xsl:value-of select="@default-value"/>L</xsl:when>
      <xsl:when test="@value-type = 'float'"><xsl:value-of select="@default-value"/>f</xsl:when>
      <xsl:when test="@value-type = 'Float'"><xsl:value-of select="@default-value"/>f</xsl:when>
      <xsl:when test="@value-type = 'double'"><xsl:value-of select="@default-value"/>d</xsl:when>
      <xsl:when test="@value-type = 'Double'"><xsl:value-of select="@default-value"/>d</xsl:when>
      <xsl:when test="@value-type = 'java.util.Date'">toDate("<xsl:value-of select="@format" disable-output-escaping="yes"/>", "<xsl:value-of select="@default-value" disable-output-escaping="yes"/>")</xsl:when>
      <xsl:otherwise><xsl:value-of select="@default-value" disable-output-escaping="yes"/></xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="hash-line">
   <xsl:param name="field" select="."/>
   
   <xsl:variable name="value-type" select="$field/@value-type" />
   <xsl:variable name="value-type-element" select="$field/@value-type-element" />
   
   <xsl:choose>
      <xsl:when test="$field/@primitive='true' and ($field/@type='array' or $field/@type='list' or $field/@type='set')">
         <xsl:value-of select="$empty"/>      for (<xsl:value-of select="$value-type-element" /> e : <xsl:value-of select="$field/@field-name" />) {<xsl:value-of select="$empty-line"/>
         <xsl:choose>
            <xsl:when test="$value-type-element='boolean'">
               <xsl:value-of select="$empty"/>         hash = hash * 31 + (e ? 1 : 0);<xsl:value-of select="$empty-line"/>
            </xsl:when>
            <xsl:when test="$value-type-element='int' or $value-type-element='short' or $value-type-element='byte'">
               <xsl:value-of select="$empty"/>         hash = hash * 31 + e;<xsl:value-of select="$empty-line"/>
            </xsl:when>
            <xsl:when test="$value-type-element='long'">
               <xsl:value-of select="$empty"/>         hash = hash * 31 + (int) (e ^ (e<xsl:value-of select="' &gt;&gt;&gt;'" disable-output-escaping="yes"/> 32));<xsl:value-of select="$empty-line"/>
            </xsl:when>
            <xsl:when test="$value-type-element='double'">
               <xsl:value-of select="$empty"/>         hash = hash * 31 + (int) (Double.doubleToLongBits(e) ^ (Double.doubleToLongBits(e) <xsl:value-of select="'&gt;&gt;&gt;'" disable-output-escaping="yes"/> 32));<xsl:value-of select="$empty-line"/>
            </xsl:when>
            <xsl:when test="$value-type-element='float'">
               <xsl:value-of select="$empty"/>         hash = hash * 31 + Float.floatToIntBits(e);<xsl:value-of select="$empty-line"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="$empty"/>         hash = hash * 31 + (int) e;<xsl:value-of select="$empty-line"/>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
         <xsl:value-of select="$empty-line"/>
      </xsl:when>
      <xsl:when test="$field/@type='array' or $field/@type='list' or $field/@type='set'">
         <xsl:value-of select="$empty"/>      for (<xsl:value-of select="$value-type-element" /> e : <xsl:value-of select="$field/@field-name" />) {<xsl:value-of select="$empty-line"/>
         <xsl:choose>
            <xsl:when test="$value-type-element='Boolean'">
               <xsl:value-of select="$empty"/>         hash = hash * 31 + (e == null ? 0: (e.booleanValue() ? 1 : 0));<xsl:value-of select="$empty-line"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="$empty"/>         hash = hash * 31 + (e == null ? 0 :e.hashCode());<xsl:value-of select="$empty-line"/>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:value-of select="$empty"/>      }<xsl:value-of select="$empty-line"/>
         <xsl:value-of select="$empty-line"/>
      </xsl:when>
      <xsl:when test="$field/@primitive='true'">
         <xsl:choose>
            <xsl:when test="$value-type='boolean'">
               <xsl:value-of select="$empty"/>      hash = hash * 31 + (<xsl:value-of select="$field/@field-name"/> ? 1 : 0);<xsl:value-of select="$empty-line"/>
            </xsl:when>
            <xsl:when test="$value-type='int' or $value-type='short' or $value-type='byte'">
               <xsl:value-of select="$empty"/>      hash = hash * 31 + <xsl:value-of select="$field/@field-name"/>;<xsl:value-of select="$empty-line"/>
            </xsl:when>
            <xsl:when test="$value-type='long'">
               <xsl:value-of select="$empty"/>      hash = hash * 31 + (int) (<xsl:value-of select="$field/@field-name"/> ^ (<xsl:value-of select="$field/@field-name"/><xsl:value-of select="' &gt;&gt;&gt;'" disable-output-escaping="yes"/> 32));<xsl:value-of select="$empty-line"/>
            </xsl:when>
            <xsl:when test="$value-type='double'">
               <xsl:value-of select="$empty"/>      hash = hash * 31 + (int) (Double.doubleToLongBits(<xsl:value-of select="$field/@field-name"/>) ^ (Double.doubleToLongBits(<xsl:value-of select="$field/@field-name"/>) <xsl:value-of select="'&gt;&gt;&gt;'" disable-output-escaping="yes"/> 32));<xsl:value-of select="$empty-line"/>
            </xsl:when>
            <xsl:when test="$value-type='float'">
               <xsl:value-of select="$empty"/>      hash = hash * 31 + Float.floatToIntBits(<xsl:value-of select="$field/@field-name"/>);<xsl:value-of select="$empty-line"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="$empty"/>      hash = hash * 31 + (int) <xsl:value-of select="$field/@field-name"/>;<xsl:value-of select="$empty-line"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
         <xsl:value-of select="$empty"/>      hash = hash * 31 + (<xsl:value-of select="$field/@field-name"/> == null ? 0 : <xsl:value-of select="$field/@field-name"/>.hashCode());<xsl:value-of select="$empty-line"/>
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template name="parent-value-type">
   <xsl:param name="entity" select="."/>
   
   <xsl:choose>
      <xsl:when test="$entity/@parent='true' and $entity/@parent-entity">
         <xsl:value-of select="/model/entity[@name = $entity/@parent-entity]/@class-name"/>
      </xsl:when>
      <xsl:when test="$entity/@parent='true'">Object</xsl:when>
   </xsl:choose>
</xsl:template>

<xsl:template name="snippets" xmlns:str="xalan://org.unidal.codegen.xsl.StringFunction">
   <xsl:if test="snippet[@lang='java']">
      <xsl:value-of select="$empty"/>   /********* Code Snippet Start *********/<xsl:value-of select="$empty-line"/>
      <xsl:for-each select="snippet[@lang='java']">
         <xsl:value-of select="str:trimMethod(text(), 3)" disable-output-escaping="yes" />
         <xsl:value-of select="$empty-line"/>
      </xsl:for-each>
      <xsl:value-of select="$empty"/>   /********* Code Snippet End *********/<xsl:value-of select="$empty-line"/>
   </xsl:if>
</xsl:template>

</xsl:stylesheet>
