/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class SharedContext {
    private Map<Object, Map<String, Object>> m_map = new HashMap<Object, Map<String, Object>>();

    public <T> T getAttribute(Object category, String key) {
        Map<String, Object> map = this.getCategoryMap(category, false);
        return (T)map.get(key);
    }

    public <T> Map<String, T> getAttributes(Object category) {
        Map<String, Object> map = this.getCategoryMap(category, false);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> e : map.entrySet()) {
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    private synchronized Map<String, Object> getCategoryMap(Object category, boolean createIfNotExist) {
        Map<String, Object> map = this.m_map.get(category);
        if (map == null && createIfNotExist) {
            map = new LinkedHashMap<String, Object>();
            this.m_map.put(category, map);
        }
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public boolean hasAttribute(Object category, String key) {
        Map<String, Object> map = this.getCategoryMap(category, false);
        return map.containsKey(key);
    }

    public void setAttribute(Object category, String key, Object value) {
        Map<String, Object> map = this.getCategoryMap(category, true);
        map.put(key, value);
    }
}

