package job;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

/**
 * This class is not required for job-installer plugin to run, but the installer
 * generated by the job installer plugin will use it to extract the job installer jar automatically.<p>
 */
public class JobInstaller {
	public static void main(String[] args) {
		String jar = System.getProperty("java.class.path");
		String basePath = args.length > 0 ? args[0] : jar.substring(0, jar.lastIndexOf('-'));
		File baseDir = new File(basePath);

		try {
			int count = unzip(new File(jar), baseDir, JobInstaller.class.getName().replace('.', '/') + ".class",
			      "META-INF/MANIFEST.MF");

			System.out.println(String.format("%s files extracted to %s successfully.", count, baseDir.getCanonicalPath()));
			System.exit(0);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(-1);
		}
	}

	private static int unzip(File sourceJar, File targetBaseDir, String... excludes) throws ZipException, IOException {
		JarFile zip = new JarFile(sourceJar);
		List<? extends ZipEntry> entries = Collections.list(zip.entries());
		Set<String> excludesSet = new HashSet<String>(Arrays.asList(excludes));
		int count = 0;

		for (ZipEntry entry : entries) {
			String name = entry.getName();

			if (!excludesSet.contains(name)) {
				if (!entry.isDirectory()) {
					File file = new File(targetBaseDir, name);
					InputStream in = zip.getInputStream(entry);

					file.getParentFile().mkdirs();
					writeToFile(file, in);
					count++;
				}
			}
		}

		zip.close();
		return count;
	}

	private static void writeToFile(File file, InputStream in) throws IOException {
		FileOutputStream out = new FileOutputStream(file);
		byte[] data = new byte[2048];

		while (true) {
			int size = in.read(data);

			if (size < 0) {
				break;
			}

			out.write(data, 0, size);
		}

		out.close();
		in.close();
	}
}
