/*
 * Decompiled with CFR 0.152.
 */
package job;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class JobInstaller {
    public static void main(String[] args) {
        String jar = System.getProperty("java.class.path");
        String basePath = args.length > 0 ? args[0] : jar.substring(0, jar.lastIndexOf(45));
        File baseDir = new File(basePath);
        try {
            int count = JobInstaller.unzip(new File(jar), baseDir, JobInstaller.class.getName().replace('.', '/') + ".class", "META-INF/MANIFEST.MF");
            System.out.println(String.format("%s files extracted to %s successfully.", count, baseDir.getCanonicalPath()));
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static int unzip(File sourceJar, File targetBaseDir, String ... excludes) throws ZipException, IOException {
        JarFile zip = new JarFile(sourceJar);
        ArrayList<JarEntry> entries = Collections.list(zip.entries());
        HashSet<String> excludesSet = new HashSet<String>(Arrays.asList(excludes));
        int count = 0;
        for (ZipEntry zipEntry : entries) {
            String name = zipEntry.getName();
            if (excludesSet.contains(name) || zipEntry.isDirectory()) continue;
            File file = new File(targetBaseDir, name);
            InputStream in = zip.getInputStream(zipEntry);
            file.getParentFile().mkdirs();
            JobInstaller.writeToFile(file, in);
            ++count;
        }
        zip.close();
        return count;
    }

    private static void writeToFile(File file, InputStream in) throws IOException {
        int size;
        FileOutputStream out = new FileOutputStream(file);
        byte[] data = new byte[2048];
        while ((size = in.read(data)) >= 0) {
            out.write(data, 0, size);
        }
        out.close();
        in.close();
    }
}

