/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.project;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.unidal.helper.Files;

public class HadoopJobMojo
extends AbstractMojo {
    protected MavenProject m_project;
    protected String outputDir;
    protected boolean verbose;

    private void addMainClassAndManifest(Archiver a, File dir, File artifactJar, String classpath) throws IOException, ArchiverException {
        String manifestName = "META-INF/MANIFEST.MF";
        JarFile jar = new JarFile(artifactJar);
        Manifest manifest = jar.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        String mainClassName = attributes.getValue("Main-Class");
        if (mainClassName == null) {
            jar.close();
            throw new IllegalStateException(String.format("No Main-Class entry is found in jar(%s)!", artifactJar));
        }
        String mainClassPath = mainClassName.replace('.', '/') + ".class";
        ZipEntry entry = jar.getEntry(mainClassPath);
        File mainClassFile = File.createTempFile("main", "class");
        Files.forIO().copy(jar.getInputStream(entry), (OutputStream)new FileOutputStream(mainClassFile), Files.AutoClose.INPUT_OUTPUT);
        jar.close();
        attributes.putValue("Class-Path", classpath);
        File manifestFile = new File(dir, manifestName);
        manifestFile.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(manifestFile);
        manifest.write(fos);
        fos.close();
        a.addFile(manifestFile, manifestName);
        a.addFile(mainClassFile, mainClassPath);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String jarName = this.m_project.getArtifactId() + "-" + this.m_project.getVersion() + "-job.jar";
        ZipArchiver a = new ZipArchiver();
        a.setDestFile(new File(this.outputDir, jarName));
        try {
            List elements = this.m_project.getRuntimeClasspathElements();
            this.makeArchive((Archiver)a, this.m_project.getBuild().getDirectory(), this.m_project.getExecutionProject().getArtifact().getFile(), elements);
            a.createArchive();
            this.getLog().info((CharSequence)String.format("File(%s) created.", a.getDestFile().getCanonicalPath()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Fail to resolve runtime classpath!", e);
        }
    }

    void makeArchive(Archiver a, String baseDir, File artifactJar, List<String> elements) throws Exception {
        StringBuilder classpath = new StringBuilder(2048);
        String mainJar = "lib/" + artifactJar.getName();
        a.addFile(artifactJar, mainJar);
        classpath.append(". ").append(mainJar);
        for (String element : elements) {
            File file = new File(element);
            if (!file.isFile()) continue;
            String name = "lib/" + file.getName();
            a.addFile(file, name);
            classpath.append(' ').append(name);
        }
        File tmpDir = new File(baseDir, "hadoop-job");
        this.addMainClassAndManifest(a, tmpDir, artifactJar, classpath.toString());
        if (this.verbose) {
            this.getLog().info((CharSequence)classpath);
        }
    }
}

