/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import job.JobInstaller;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.unidal.helper.Files;

public class JobInstallerMojo
extends AbstractMojo {
    protected MavenProject m_project;
    protected String outputDir;
    protected boolean verbose;

    private void addMainClass(Archiver a, File dir) throws IOException, ArchiverException {
        String mainClassName = JobInstaller.class.getName().replace('.', '/') + ".class";
        File mainClassFile = new File(dir, mainClassName);
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/" + mainClassName);
        Files.forIO().writeTo(mainClassFile, Files.forIO().readFrom(in));
        a.addFile(mainClassFile, mainClassName);
    }

    private void addManifest(Archiver a, File dir) throws IOException, ArchiverException {
        StringBuilder manifest = new StringBuilder(4096);
        manifest.append("Manifest-Version: 1.0\r\n");
        manifest.append("Created-By: JobInstallerMojo\r\n");
        manifest.append("Main-Class: ").append(JobInstaller.class.getName()).append("\r\n");
        String manifestName = "META-INF/MANIFEST.MF";
        File manifestFile = new File(dir, manifestName);
        Files.forIO().writeTo(manifestFile, manifest.toString(), "utf-8");
        a.addFile(manifestFile, manifestName);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String jarName = this.m_project.getArtifactId() + "-" + this.m_project.getVersion() + "-installer.jar";
        ZipArchiver a = new ZipArchiver();
        a.setDestFile(new File(this.outputDir, jarName));
        try {
            List elements = this.m_project.getRuntimeClasspathElements();
            this.makeArchive((Archiver)a, this.m_project.getExecutionProject().getArtifact().getFile(), elements);
            a.createArchive();
            this.getLog().info((CharSequence)String.format("File(%s) created.", a.getDestFile().getCanonicalPath()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Fail to resolve runtime classpath!", e);
        }
    }

    private void makeArchive(Archiver a, File artifactJar, List<String> elements) throws Exception {
        StringBuilder classpath = new StringBuilder(2048);
        a.addFile(artifactJar, artifactJar.getName());
        for (String element : elements) {
            File file = new File(element);
            if (!file.isFile()) continue;
            String name = "lib/" + file.getName();
            a.addFile(file, name);
            if (classpath.length() == 0) {
                classpath.append(name);
                continue;
            }
            classpath.append(File.pathSeparatorChar).append(name);
        }
        File tmpDir = new File(this.m_project.getBuild().getDirectory(), "job-installer");
        this.addMainClass(a, tmpDir);
        this.addManifest(a, tmpDir);
        if (this.verbose) {
            this.getLog().info((CharSequence)classpath);
        }
    }
}

