/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.project;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.unidal.codegen.helper.PropertyProviders;
import org.unidal.helper.Files;
import org.unidal.helper.Joiners;
import org.unidal.helper.Scanners;
import org.unidal.helper.Splitters;

public class MigrateMojo
extends AbstractMojo {
    private MavenProject project;
    private String sourcePackage;
    private String targetPackage;
    private boolean verbose;
    private String m_reversedSourcePackage;
    private String m_reversedTargetPackage;
    private int m_success;
    private int m_changed;
    private int m_failure;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.sourcePackage = PropertyProviders.fromConsole().forString("sourcePackage", "Java source package:", this.sourcePackage, null);
        this.targetPackage = PropertyProviders.fromConsole().forString("targetPackage", "Java target package:", this.targetPackage, null);
        this.m_reversedSourcePackage = this.reversePackage(this.sourcePackage);
        this.m_reversedTargetPackage = this.reversePackage(this.targetPackage);
        try {
            long start = System.currentTimeMillis();
            File baseDir = this.project.getBasedir().getCanonicalFile();
            final HashSet<String> sourceFolders = new HashSet<String>();
            this.m_success = 0;
            this.m_changed = 0;
            this.m_failure = 0;
            for (String source : this.project.getCompileSourceRoots()) {
                sourceFolders.add(source);
            }
            for (String testSource : this.project.getTestCompileSourceRoots()) {
                sourceFolders.add(testSource);
            }
            for (Resource resource : this.project.getResources()) {
                sourceFolders.add(resource.getDirectory());
            }
            for (Resource testResource : this.project.getTestResources()) {
                sourceFolders.add(testResource.getDirectory());
            }
            if (new File(baseDir, "pom.xml").exists()) {
                this.migrateFile(new File(baseDir, "pom.xml"), new File(baseDir, "pom.xml"));
            }
            if ("war".equals(this.project.getPackaging())) {
                sourceFolders.add("src/main/webapp");
            }
            Scanners.forDir().scan(baseDir, (Scanners.IMatcher)new Scanners.FileMatcher(){

                public Scanners.IMatcher.Direction matches(File base, String path) {
                    if (path.equals("src") || path.startsWith("src/")) {
                        List parts = Splitters.by((char)'/').split(path);
                        if (parts.size() == 3) {
                            sourceFolders.add(path);
                            return Scanners.IMatcher.Direction.MATCHED;
                        }
                        return Scanners.IMatcher.Direction.DOWN;
                    }
                    return Scanners.IMatcher.Direction.NEXT;
                }
            });
            for (String sourceFolder : sourceFolders) {
                this.migrateSource(baseDir, baseDir, sourceFolder);
            }
            long timeUsed = System.currentTimeMillis() - start;
            this.getLog().info((CharSequence)String.format("%s files migrated in %s ms, with %s changed and %s failures.", this.m_success, timeUsed, this.m_changed, this.m_failure));
        }
        catch (Exception e) {
            String message = String.format("Error when migrating project[sourcePackage: %s, targetPackage: %s", this.sourcePackage, this.targetPackage);
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message, (Throwable)e);
        }
    }

    protected void migrateDirectory(File source, File target, String sourcePath, String sourcePackageName) {
        String targetPath;
        if (sourcePackageName != null && sourcePackageName.startsWith(this.sourcePackage)) {
            String targetPackageName = this.targetPackage + sourcePackageName.substring(this.sourcePackage.length());
            targetPath = targetPackageName.replace('.', '/');
        } else {
            targetPath = sourcePath;
        }
        File base = sourcePath == null ? source : new File(source, sourcePath);
        String[] names = base.list();
        if (names != null) {
            for (String name : names) {
                File file = new File(base, name);
                if (file.isDirectory()) {
                    String newPath = sourcePath == null ? name : sourcePath + "/" + name;
                    String newPackageName = sourcePackageName == null ? name : sourcePackageName + "." + name;
                    this.migrateDirectory(source, target, newPath, newPackageName);
                    continue;
                }
                if (!file.isFile()) continue;
                if (targetPath == null) {
                    this.migrateFile(file, new File(target, name));
                    continue;
                }
                this.migrateFile(file, new File(target, targetPath + "/" + name));
            }
        }
    }

    protected void migrateFile(File source, File target) {
        String path = source.getPath();
        if (path.endsWith(".java") || path.endsWith(".xml") || path.endsWith(".properties")) {
            try {
                boolean changed;
                String encoding = "utf-8";
                String original = Files.forIO().readFrom(source, encoding);
                String migrated = this.replaceAll(original, this.sourcePackage, this.targetPackage);
                migrated = this.replaceAll(migrated, this.m_reversedSourcePackage, this.m_reversedTargetPackage);
                Files.forIO().writeTo(target, migrated, encoding);
                ++this.m_success;
                boolean bl = changed = !original.equals(migrated);
                if (changed) {
                    ++this.m_changed;
                }
                if (this.verbose) {
                    if (changed) {
                        this.getLog().info((CharSequence)String.format("File(%s) migrated, content length is %s.", target, target.length()));
                    } else {
                        this.getLog().info((CharSequence)String.format("File(%s) copied, content length is %s.", target, target.length()));
                    }
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)String.format("Error when migrating file(%s)!", source), (Throwable)e);
                ++this.m_failure;
            }
        }
    }

    protected void migrateSource(File sourceBase, File targetBase, String path) {
        String basePath = sourceBase.getPath();
        String relativePath = path.startsWith(basePath) ? path.substring(basePath.length()) : path;
        File source = new File(sourceBase, relativePath);
        File target = new File(targetBase, relativePath);
        this.migrateDirectory(source, target, null, null);
    }

    protected String replaceAll(String source, String fromToken, String toToken) {
        int toLength = toToken.length();
        int fromLength = fromToken.length();
        StringBuilder sb = new StringBuilder(source.length() + (toLength < fromLength ? 0 : toLength - fromLength) * 30);
        int offset = 0;
        int index = source.indexOf(fromToken, offset);
        while (true) {
            if (index == -1) break;
            sb.append(source.substring(offset, index));
            sb.append(toToken);
            offset = index + fromLength;
            index = source.indexOf(fromToken, offset);
        }
        sb.append(source.substring(offset));
        return sb.toString();
    }

    protected String reversePackage(String packageName) {
        List parts = Splitters.by((char)'.').split(packageName);
        Collections.reverse(parts);
        return Joiners.by((char)'.').join((Collection)parts);
    }
}

