/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.project;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.unidal.helper.Files;
import org.unidal.helper.Scanners;
import org.unidal.helper.Splitters;

public class MigrateTermMojo
extends AbstractMojo {
    private MavenProject project;
    private String m_from;
    private String m_to;
    private boolean verbose;
    private String m_from2;
    private String m_to2;
    private int m_success;
    private int m_changed;
    private int m_failure;

    private String capitalize(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (i == 0) {
                sb.append(Character.toUpperCase(ch));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.m_from2 = this.capitalize(this.m_from);
        this.m_to2 = this.capitalize(this.m_to);
        try {
            long start = System.currentTimeMillis();
            final HashSet<File> sourceFolders = new HashSet<File>();
            File baseDir = this.project.getBasedir().getCanonicalFile();
            this.m_success = 0;
            this.m_changed = 0;
            this.m_failure = 0;
            for (String source : this.project.getCompileSourceRoots()) {
                sourceFolders.add(new File(source));
            }
            for (String testSource : this.project.getTestCompileSourceRoots()) {
                sourceFolders.add(new File(testSource));
            }
            for (Resource resource : this.project.getResources()) {
                sourceFolders.add(new File(resource.getDirectory()));
            }
            for (Resource testResource : this.project.getTestResources()) {
                sourceFolders.add(new File(testResource.getDirectory()));
            }
            if (new File(baseDir, "pom.xml").exists()) {
                this.migrateFile(new File(baseDir, "pom.xml"), new File(baseDir, "pom.xml"));
            }
            if ("war".equals(this.project.getPackaging())) {
                sourceFolders.add(new File(baseDir, "src/main/webapp"));
            }
            Scanners.forDir().scan(baseDir, (Scanners.IMatcher)new Scanners.FileMatcher(){

                public Scanners.IMatcher.Direction matches(File base, String path) {
                    if (path.equals("src") || path.startsWith("src/")) {
                        List parts = Splitters.by((char)'/').split(path);
                        if (parts.size() == 3) {
                            sourceFolders.add(new File(base, path));
                            return Scanners.IMatcher.Direction.MATCHED;
                        }
                        return Scanners.IMatcher.Direction.DOWN;
                    }
                    return Scanners.IMatcher.Direction.NEXT;
                }
            });
            for (File sourceFolder : sourceFolders) {
                this.migrateDirectory(sourceFolder);
            }
            long timeUsed = System.currentTimeMillis() - start;
            this.getLog().info((CharSequence)String.format("%s files migrated in %s ms, with %s changed and %s failures.", this.m_success, timeUsed, this.m_changed, this.m_failure));
        }
        catch (Exception e) {
            String message = String.format("Error when migrating term from %s to %s!.", this.m_from, this.m_to);
            this.getLog().error((CharSequence)message);
            throw new MojoFailureException(message, (Throwable)e);
        }
    }

    protected void migrateDirectory(File dir) {
        this.migrateDirectory(dir, dir);
    }

    protected void migrateDirectory(File sourceDir, File targetDir) {
        String[] names = sourceDir.list();
        if (names != null) {
            for (String name : names) {
                File source = new File(sourceDir, name);
                File target = name.contains(this.m_from) ? new File(targetDir, this.replace(name, this.m_from, this.m_to)) : (name.contains(this.m_from2) ? new File(targetDir, this.replace(name, this.m_from2, this.m_to2)) : new File(targetDir, name));
                if (source.isDirectory()) {
                    this.migrateDirectory(source, target);
                    continue;
                }
                if (!source.isFile()) continue;
                this.migrateFile(source, target);
            }
        }
    }

    protected void migrateFile(File source, File target) {
        try {
            boolean changed;
            String encoding = "utf-8";
            String original = Files.forIO().readFrom(source, encoding);
            String migrated = this.replaceAll(original, this.m_from, this.m_to);
            migrated = this.replaceAll(migrated, this.m_from2, this.m_to2);
            Files.forIO().writeTo(target, migrated, encoding);
            ++this.m_success;
            boolean bl = changed = !original.equals(migrated);
            if (changed) {
                ++this.m_changed;
            }
            if (this.verbose && changed) {
                this.getLog().info((CharSequence)String.format("File(%s) migrated, length is %s.", target, target.length()));
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)String.format("Error when migrating file(%s)!", source), (Throwable)e);
            ++this.m_failure;
        }
    }

    private String replace(String str, String from, String to) {
        int pos = str.indexOf(from);
        if (pos >= 0) {
            return str.substring(0, pos) + to + str.substring(pos + from.length());
        }
        return str;
    }

    protected String replaceAll(String source, String fromToken, String toToken) {
        int toLength = toToken.length();
        int fromLength = fromToken.length();
        StringBuilder sb = new StringBuilder(source.length() + (toLength < fromLength ? 0 : toLength - fromLength) * 30);
        int offset = 0;
        int index = source.indexOf(fromToken, offset);
        while (true) {
            if (index == -1) break;
            sb.append(source.substring(offset, index));
            sb.append(toToken);
            offset = index + fromLength;
            index = source.indexOf(fromToken, offset);
        }
        sb.append(source.substring(offset));
        return sb.toString();
    }
}

