/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.project;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;

public class PackageMojo
extends AbstractMojo {
    private MavenProject project;
    private String excludeDirs;
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*"};

    public void execute() throws MojoExecutionException, MojoFailureException {
        File baseDir = this.project.getBasedir();
        String targetDirectory = this.project.getBuild().getDirectory();
        String outputFile = targetDirectory + "/" + baseDir.getName() + ".sources.jar";
        try {
            ZipArchiver a = new ZipArchiver();
            String[] list = baseDir.list();
            List<String> dirs = this.getExcludedDirs();
            String[] excludes = this.getDefaultExcludes();
            for (String item : list) {
                if (item.startsWith(".") || dirs.contains(item)) continue;
                File file = new File(baseDir, item);
                if (file.isFile()) {
                    a.addFile(file, item);
                    continue;
                }
                if (!file.isDirectory() || file.getPath().equals(targetDirectory)) continue;
                DefaultFileSet fs = new DefaultFileSet(file);
                fs.setPrefix(item + "/");
                fs.include(DEFAULT_INCLUDES);
                fs.exclude(excludes);
                a.addFileSet((FileSet)fs);
            }
            a.setDestFile(new File(outputFile));
            a.createArchive();
            this.getLog().info((CharSequence)String.format("File(%s) created.", a.getDestFile().getCanonicalPath()));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can't create archiver: " + outputFile, e);
        }
    }

    private String[] getDefaultExcludes() {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add(".*");
        excludes.add("**/.*");
        excludes.add("**/.*/**");
        excludes.add("**/WEB-INF/tmp");
        excludes.add("**/target");
        excludes.add("**/target/**/*");
        excludes.add("**/*.jar");
        for (String exclude : FileUtils.getDefaultExcludes()) {
            excludes.add(exclude);
        }
        return excludes.toArray(new String[0]);
    }

    private List<String> getExcludedDirs() {
        ArrayList<String> excludes = new ArrayList<String>();
        for (String exclude : this.excludeDirs.split(",")) {
            excludes.add(exclude);
        }
        return excludes;
    }
}

