/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.project;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.unidal.helper.Scanners;

public class SourceMojo
extends AbstractMojo {
    private MavenProject m_project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String outputDir = this.m_project.getBuild().getDirectory();
        final LinkedHashSet<String> paths = new LinkedHashSet<String>();
        Scanners.forDir().scan(new File(outputDir), (Scanners.IMatcher)new Scanners.FileMatcher(){

            public Scanners.IMatcher.Direction matches(File base, String path) {
                if (path.startsWith("generated-")) {
                    if (path.endsWith(".java")) {
                        int pos = path.indexOf("/src/");
                        if (pos < 0) {
                            int off = path.indexOf(47);
                            if (off > 0) {
                                paths.add("target/" + path.substring(0, off));
                            }
                        } else {
                            int off = path.indexOf("/java/", pos);
                            if (off < 0) {
                                off = path.indexOf("/resources/", pos);
                                if (off > 0) {
                                    paths.add("target/" + path.substring(0, off + "/resources".length()));
                                }
                            } else {
                                paths.add("target/" + path.substring(0, off + "/java".length()));
                            }
                        }
                    } else {
                        return Scanners.IMatcher.Direction.DOWN;
                    }
                }
                return Scanners.IMatcher.Direction.NEXT;
            }
        });
        try {
            this.modifyClasspathFile(paths);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to add generated source to classpath!", e);
        }
    }

    protected void modifyClasspathFile(Set<String> paths) throws Exception {
        File file = new File(this.m_project.getBasedir(), ".classpath");
        if (!file.exists()) {
            throw new IllegalStateException("Please run 'mvn eclipse:eclipse' first!");
        }
        Document doc = new SAXBuilder().build(file);
        Element classpath = doc.getRootElement();
        List entries = classpath.getChildren();
        for (Element entry : entries) {
            String kind = entry.getAttributeValue("kind");
            String path = entry.getAttributeValue("path");
            if (kind == null || !kind.equals("src") || path == null) continue;
            paths.remove(path);
        }
        boolean dirty = false;
        for (String path : paths) {
            Element entry = new Element("classpathentry");
            entry.setAttribute("kind", "src");
            entry.setAttribute("path", path);
            classpath.addContent((Content)entry);
            dirty = true;
            this.getLog().info((CharSequence)String.format("Adding %s to source folder ...", path));
        }
        if (dirty) {
            this.saveXml(doc, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveXml(Document doc, File file) throws IOException {
        File parent = file.getCanonicalFile().getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        Format format = Format.getPrettyFormat().setIndent("   ");
        XMLOutputter outputter = new XMLOutputter(format);
        try (FileWriter writer = new FileWriter(file);){
            outputter.output(doc, (Writer)writer);
            this.getLog().info((CharSequence)("File " + file.getCanonicalPath() + " saved."));
        }
    }
}

