/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.project;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.unidal.helper.Files;
import org.unidal.helper.Scanners;
import org.unidal.tuple.Ref;

public class StartTestServerMojo
extends AbstractMojo {
    private MavenProject m_project;
    private boolean verbose;

    private String detectTestServerName() throws MojoExecutionException {
        final Ref testServerName = new Ref();
        Scanners.forDir().scan(new File("target/test-classes"), (Scanners.IMatcher)new Scanners.FileMatcher(){

            public Scanners.IMatcher.Direction matches(File base, String path) {
                if (testServerName.getValue() == null && path.endsWith("/TestServer.class")) {
                    String className = path.substring(0, path.length() - 6).replace('/', '.');
                    testServerName.setValue((Object)className);
                }
                return Scanners.IMatcher.Direction.DOWN;
            }
        });
        if (testServerName.getValue() != null) {
            return (String)testServerName.getValue();
        }
        throw new MojoExecutionException("No TestServer was found!");
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashMap<String, String> properties = new HashMap<String, String>();
        String dependencyClasspathFile = "target/dependency.classpath";
        StringBuilder classpath = new StringBuilder(2048);
        properties.put("mdep.outputFile", dependencyClasspathFile);
        this.runMavenApplication(properties, "test-compile dependency:copy-dependencies dependency:build-classpath");
        try {
            this.copyComponentDescriptor();
            classpath.append("target/classes").append(File.pathSeparator);
            classpath.append("target/test-classes").append(File.pathSeparator);
            String dependencyClasspath = Files.forIO().readFrom(new File(dependencyClasspathFile), "utf-8");
            classpath.append(dependencyClasspath);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.toString(), (Exception)e);
        }
        String testServerName = this.detectTestServerName();
        this.runJavaApplication(classpath.toString(), testServerName, null);
    }

    private void copyComponentDescriptor() throws IOException {
        File from = new File(this.m_project.getBasedir(), "src/main/resources/META-INF/plexus/components.xml");
        File to = new File(this.m_project.getBasedir(), "target/classes/META-INF/plexus/components.xml");
        File dir = to.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        Files.forDir().copyFile(from, to);
    }

    protected void runJavaApplication(String classpath, String application, Map<String, String> properties) throws MojoExecutionException {
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.m_project.getBasedir());
        cli.setExecutable("java");
        StringBuilder sb = new StringBuilder(4096);
        if (classpath != null) {
            sb.append("-cp \"").append(classpath).append("\" ");
        }
        if (properties != null) {
            for (Map.Entry<String, String> e : properties.entrySet()) {
                String name = e.getKey();
                String value = e.getValue();
                sb.append("-D").append(name).append("=");
                if (value.indexOf(32) >= 0) {
                    sb.append("\"").append(value).append("\"");
                } else {
                    sb.append(value);
                }
                sb.append(' ');
            }
        }
        sb.append(application);
        Arg arg = cli.createArg();
        arg.setLine(sb.toString());
        if (this.verbose) {
            this.getLog().info((CharSequence)("Executing java " + sb));
        }
        try {
            CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String line) {
                    StartTestServerMojo.this.getLog().info((CharSequence)line);
                }
            }, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String line) {
                    StartTestServerMojo.this.getLog().error((CharSequence)line);
                }
            });
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Fail to execute java command!", (Exception)((Object)e));
        }
    }

    protected void runMavenApplication(Map<String, String> properties, String ... arguments) throws MojoExecutionException {
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.m_project.getBasedir());
        cli.setExecutable("mvn");
        StringBuilder sb = new StringBuilder(4096);
        if (properties != null) {
            for (Map.Entry entry : properties.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                sb.append("-D").append(name).append("=");
                if (value.indexOf(32) >= 0) {
                    sb.append("\"").append(value).append("\"");
                } else {
                    sb.append(value);
                }
                sb.append(' ');
            }
        }
        for (String argument : arguments) {
            sb.append(' ').append(argument);
        }
        Arg arg = cli.createArg();
        arg.setLine(sb.toString());
        if (this.verbose) {
            this.getLog().info((CharSequence)("Executing mvn " + sb));
        }
        try {
            CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)new StreamConsumer(){
                private String m_info = "[INFO] ";
                private String m_warn = "[WARN] ";

                public void consumeLine(String line) {
                    if (line.startsWith(this.m_info)) {
                        StartTestServerMojo.this.getLog().info((CharSequence)line.substring(this.m_info.length()));
                    } else if (line.startsWith(this.m_warn)) {
                        StartTestServerMojo.this.getLog().warn((CharSequence)line.substring(this.m_warn.length()));
                    } else {
                        StartTestServerMojo.this.getLog().info((CharSequence)line);
                    }
                }
            }, (StreamConsumer)new StreamConsumer(){

                public void consumeLine(String line) {
                    StartTestServerMojo.this.getLog().error((CharSequence)line);
                }
            });
        }
        catch (CommandLineException commandLineException) {
            throw new MojoExecutionException("Fail to execute mvn command!", (Exception)((Object)commandLineException));
        }
    }
}

