/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.project.rule;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.unidal.maven.plugin.project.rule.IRule;
import org.unidal.maven.plugin.project.rule.RuleExemption;
import org.unidal.maven.plugin.project.rule.RuleFailure;
import org.unidal.maven.plugin.project.rule.RuleType;

public enum ConstructorRule implements IRule<Constructor<?>>
{
    CONSTRUCTOR_REMOVED{

        @Override
        public int compare(Constructor<?> source, Constructor<?> target) {
            int m2 = target.getModifiers();
            if (source == null && (Modifier.isPublic(m2) || Modifier.isProtected(m2))) {
                return RuleFailure.CONSTRUCTOR_REMOVED.getErrorCode();
            }
            return 0;
        }
    }
    ,
    INVISIBLE_MEMBER_CONSTRUCTOR_SKIPPED{

        @Override
        public int compare(Constructor<?> source, Constructor<?> target) {
            int m2 = target.getModifiers();
            if (!Modifier.isPublic(m2) && !Modifier.isProtected(m2)) {
                return RuleExemption.INVISIBLE_CONSTRUCTOR_SKIPPED.getReasonCode();
            }
            return 0;
        }
    }
    ,
    CONSTRUCTOR_MEMBERSHIP_CHANGED{

        @Override
        public int compare(Constructor<?> source, Constructor<?> target) {
            int m2 = target.getModifiers();
            int m1 = source.getModifiers();
            if (Modifier.isStatic(m2) != Modifier.isStatic(m1)) {
                return RuleFailure.CONSTRUCTOR_MEMBERSHIP_CHANGED.getErrorCode();
            }
            return 0;
        }
    }
    ,
    CONSTRUCTOR_VISIBILITY_DEGRADED{

        @Override
        public int compare(Constructor<?> source, Constructor<?> target) {
            int m2 = target.getModifiers();
            int m1 = source.getModifiers();
            if (Modifier.isPublic(m2) && !Modifier.isPublic(m1)) {
                return RuleFailure.CONSTRUCTOR_VISIBILITY_DEGRADED.getErrorCode();
            }
            if (Modifier.isProtected(m2) && !Modifier.isProtected(m1) && !Modifier.isPublic(m1)) {
                return RuleFailure.CONSTRUCTOR_VISIBILITY_DEGRADED.getErrorCode();
            }
            return 0;
        }
    };


    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public RuleType getType() {
        return RuleType.CONSTRUCTOR;
    }
}

