/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.project.rule;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.maven.plugin.project.rule.IRule;
import org.unidal.maven.plugin.project.rule.IRuleErrorHandler;
import org.unidal.maven.plugin.project.rule.IRuleExemptionHandler;
import org.unidal.maven.plugin.project.rule.RuleExemption;
import org.unidal.maven.plugin.project.rule.RuleFailure;
import org.unidal.maven.plugin.project.rule.RuleRegistry;

public class RuleEngine {
    private RuleRegistry m_registry = new RuleRegistry();

    protected <T extends Member> String asString(T member) {
        if (member instanceof Field) {
            return member.getName();
        }
        if (member instanceof Method) {
            return member.getName() + ":" + Arrays.asList(((Method)member).getGenericParameterTypes());
        }
        if (member instanceof Constructor) {
            return member.getName() + ":" + Arrays.asList(((Constructor)member).getGenericParameterTypes());
        }
        throw new UnsupportedOperationException();
    }

    protected <T extends Member> Map<String, List<T>> buildMemberMap(T[] members) {
        HashMap<String, List<T>> map = new HashMap<String, List<T>>();
        for (T member : members) {
            ArrayList<T> list = (ArrayList<T>)map.get(member.getName());
            if (list == null) {
                list = new ArrayList<T>(3);
                map.put(member.getName(), list);
            }
            list.add(member);
        }
        return map;
    }

    public boolean execute(Class<?> source, Class<?> target, IRuleErrorHandler errorHandler, IRuleExemptionHandler exemptionHandler) {
        if (!this.processClass(source, target, errorHandler, exemptionHandler)) {
            return false;
        }
        if (source != null) {
            Map fieldMap = this.buildMemberMap(source.getDeclaredFields());
            for (Field targetField : target.getDeclaredFields()) {
                Field sourceField = this.findMember(fieldMap, targetField);
                if (this.processField(sourceField, targetField, errorHandler, exemptionHandler)) continue;
                return false;
            }
            Map methodMap = this.buildMemberMap(source.getDeclaredMethods());
            for (Method targetMethod : target.getDeclaredMethods()) {
                Method sourceMethod = this.findMember(methodMap, targetMethod);
                if (this.processMethod(sourceMethod, targetMethod, errorHandler, exemptionHandler)) continue;
                return false;
            }
            Map constructorMap = this.buildMemberMap(source.getDeclaredConstructors());
            for (Constructor<?> targetConstructor : target.getDeclaredConstructors()) {
                Constructor<?> sourceConstructor = this.findMember(constructorMap, targetConstructor);
                if (this.processConstructor(sourceConstructor, targetConstructor, errorHandler, exemptionHandler)) continue;
                return false;
            }
        }
        return true;
    }

    protected <T extends Member> T findMember(Map<String, List<T>> map, T target) {
        Member source = null;
        List<T> list = map.get(target.getName());
        if (list != null) {
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                Member member = (Member)list.get(i);
                if (!this.asString(member).equals(this.asString(target))) continue;
                list.remove(i);
                source = member;
                break;
            }
        }
        return (T)source;
    }

    public RuleRegistry getRegistry() {
        return this.m_registry;
    }

    protected boolean processClass(Class<?> source, Class<?> target, IRuleErrorHandler errorHandler, IRuleExemptionHandler exemptionHandler) {
        Map<String, IRule<AnnotatedElement>> rules = this.m_registry.getClassRules();
        for (IRule<AnnotatedElement> rule : rules.values()) {
            int value = rule.compare(source, target);
            if (value < 0) {
                RuleFailure failure = RuleFailure.getByErrorCode(value);
                errorHandler.onError(source, target, failure);
                return false;
            }
            if (value <= 0) continue;
            RuleExemption exemption = RuleExemption.getByReasonCode(value);
            exemptionHandler.onExemption(source, target, exemption);
            return false;
        }
        return true;
    }

    protected boolean processConstructor(Constructor<?> source, Constructor<?> target, IRuleErrorHandler errorHandler, IRuleExemptionHandler exemptionHandler) {
        Map<String, IRule<AnnotatedElement>> rules = this.m_registry.getConstructorRules();
        for (IRule<AnnotatedElement> rule : rules.values()) {
            int value = rule.compare(source, target);
            if (value < 0) {
                RuleFailure failure = RuleFailure.getByErrorCode(value);
                errorHandler.onError(source, target, failure);
                return false;
            }
            if (value <= 0) continue;
            RuleExemption exemption = RuleExemption.getByReasonCode(value);
            exemptionHandler.onExemption(source, target, exemption);
            return false;
        }
        return true;
    }

    protected boolean processField(Field source, Field target, IRuleErrorHandler errorHandler, IRuleExemptionHandler exemptionHandler) {
        Map<String, IRule<AnnotatedElement>> rules = this.m_registry.getFieldRules();
        for (IRule<AnnotatedElement> rule : rules.values()) {
            int value = rule.compare(source, target);
            if (value < 0) {
                RuleFailure failure = RuleFailure.getByErrorCode(value);
                errorHandler.onError(source, target, failure);
                return false;
            }
            if (value <= 0) continue;
            RuleExemption exemption = RuleExemption.getByReasonCode(value);
            exemptionHandler.onExemption(source, target, exemption);
            return false;
        }
        return true;
    }

    protected boolean processMethod(Method source, Method target, IRuleErrorHandler errorHandler, IRuleExemptionHandler exemptionHandler) {
        Map<String, IRule<AnnotatedElement>> rules = this.m_registry.getMethodRules();
        for (IRule<AnnotatedElement> rule : rules.values()) {
            int value = rule.compare(source, target);
            if (value < 0) {
                RuleFailure failure = RuleFailure.getByErrorCode(value);
                errorHandler.onError(source, target, failure);
                return false;
            }
            if (value <= 0) continue;
            RuleExemption exemption = RuleExemption.getByReasonCode(value);
            exemptionHandler.onExemption(source, target, exemption);
            return false;
        }
        return true;
    }
}

