/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.project.rule;

import java.lang.reflect.AnnotatedElement;
import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.maven.plugin.project.rule.IRule;

public class RuleRegistry {
    private Map<String, IRule<AnnotatedElement>> m_classRules = new LinkedHashMap<String, IRule<AnnotatedElement>>();
    private Map<String, IRule<AnnotatedElement>> m_fieldRules = new LinkedHashMap<String, IRule<AnnotatedElement>>();
    private Map<String, IRule<AnnotatedElement>> m_constructorRules = new LinkedHashMap<String, IRule<AnnotatedElement>>();
    private Map<String, IRule<AnnotatedElement>> m_methodRules = new LinkedHashMap<String, IRule<AnnotatedElement>>();

    public Map<String, IRule<AnnotatedElement>> getClassRules() {
        return this.m_classRules;
    }

    public Map<String, IRule<AnnotatedElement>> getConstructorRules() {
        return this.m_constructorRules;
    }

    public Map<String, IRule<AnnotatedElement>> getFieldRules() {
        return this.m_fieldRules;
    }

    public Map<String, IRule<AnnotatedElement>> getMethodRules() {
        return this.m_methodRules;
    }

    public void register(IRule<? extends AnnotatedElement> rule) {
        switch (rule.getType()) {
            case CLASS: {
                this.m_classRules.put(rule.getName(), rule);
                break;
            }
            case FIELD: {
                this.m_fieldRules.put(rule.getName(), rule);
                break;
            }
            case CONSTRUCTOR: {
                this.m_constructorRules.put(rule.getName(), rule);
                break;
            }
            case METHOD: {
                this.m_methodRules.put(rule.getName(), rule);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown rule type: " + (Object)((Object)rule.getType()));
            }
        }
    }
}

