/* THIS FILE WAS AUTO GENERATED BY codegen-maven-plugin, DO NOT EDIT IT */
package org.unidal.maven.plugin.source.lines.transform;

import static org.unidal.maven.plugin.source.lines.Constants.ATTR_CLASS;
import static org.unidal.maven.plugin.source.lines.Constants.ATTR_COMMENT;
import static org.unidal.maven.plugin.source.lines.Constants.ATTR_EMPTY;
import static org.unidal.maven.plugin.source.lines.Constants.ATTR_FILES;
import static org.unidal.maven.plugin.source.lines.Constants.ATTR_GENERATED;
import static org.unidal.maven.plugin.source.lines.Constants.ATTR_GENERATED_FILES;
import static org.unidal.maven.plugin.source.lines.Constants.ATTR_LINES;
import static org.unidal.maven.plugin.source.lines.Constants.ATTR_NAME;
import static org.unidal.maven.plugin.source.lines.Constants.ATTR_PACKAGE;
import static org.unidal.maven.plugin.source.lines.Constants.ATTR_TEST;
import static org.unidal.maven.plugin.source.lines.Constants.ATTR_TEST_FILES;
import static org.unidal.maven.plugin.source.lines.Constants.ENTITY_CLASS;
import static org.unidal.maven.plugin.source.lines.Constants.ENTITY_COUNT;
import static org.unidal.maven.plugin.source.lines.Constants.ENTITY_PROJECT;
import static org.unidal.maven.plugin.source.lines.Constants.ENTITY_ROOT;

import java.lang.reflect.Array;
import java.util.Collection;

import org.unidal.maven.plugin.source.lines.IEntity;
import org.unidal.maven.plugin.source.lines.IVisitor;
import org.unidal.maven.plugin.source.lines.entity.ClassModel;
import org.unidal.maven.plugin.source.lines.entity.CountModel;
import org.unidal.maven.plugin.source.lines.entity.ProjectModel;
import org.unidal.maven.plugin.source.lines.entity.RootModel;

public class DefaultXmlBuilder implements IVisitor {

   private IVisitor m_visitor = this;

   private int m_level;

   private StringBuilder m_sb;

   private boolean m_compact;

   public DefaultXmlBuilder() {
      this(false);
   }

   public DefaultXmlBuilder(boolean compact) {
      m_compact = compact;
   }

   public String build(IEntity<?> entity) {
      m_sb = new StringBuilder(8192);
      m_sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");

      entity.accept(m_visitor);
      return m_sb.toString();
   }

   protected void endTag(String name) {
      m_level--;

      indent();
      m_sb.append("</").append(name).append(">\r\n");
   }

   protected String escape(Object value) {
      return escape(value, false);
   }
   
   protected String escape(Object value, boolean text) {
      if (value == null) {
         return null;
      }

      String str = toString(value);
      int len = str.length();
      StringBuilder sb = new StringBuilder(len + 16);

      for (int i = 0; i < len; i++) {
         final char ch = str.charAt(i);

         switch (ch) {
         case '<':
            sb.append("&lt;");
            break;
         case '>':
            sb.append("&gt;");
            break;
         case '&':
            sb.append("&amp;");
            break;
         case '"':
            if (!text) {
               sb.append("&quot;");
               break;
            }
         default:
            sb.append(ch);
            break;
         }
      }

      return sb.toString();
   }
   
   protected void indent() {
      if (!m_compact) {
         for (int i = m_level - 1; i >= 0; i--) {
            m_sb.append("   ");
         }
      }
   }

   protected void startTag(String name) {
      startTag(name, false, null);
   }
   
   protected void startTag(String name, boolean closed, java.util.Map<String, String> dynamicAttributes, Object... nameValues) {
      startTag(name, null, closed, dynamicAttributes, nameValues);
   }

   protected void startTag(String name, java.util.Map<String, String> dynamicAttributes, Object... nameValues) {
      startTag(name, null, false, dynamicAttributes, nameValues);
   }

   protected void startTag(String name, Object text, boolean closed, java.util.Map<String, String> dynamicAttributes, Object... nameValues) {
      indent();

      m_sb.append('<').append(name);

      int len = nameValues.length;

      for (int i = 0; i + 1 < len; i += 2) {
         Object attrName = nameValues[i];
         Object attrValue = nameValues[i + 1];

         if (attrValue != null) {
            m_sb.append(' ').append(attrName).append("=\"").append(escape(attrValue)).append('"');
         }
      }

      if (dynamicAttributes != null) {
         for (java.util.Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
            m_sb.append(' ').append(e.getKey()).append("=\"").append(escape(e.getValue())).append('"');
         }
      }

      if (text != null && closed) {
         m_sb.append('>');
         m_sb.append(escape(text, true));
         m_sb.append("</").append(name).append(">\r\n");
      } else {
         if (closed) {
            m_sb.append('/');
         } else {
            m_level++;
         }
   
         m_sb.append(">\r\n");
      }
   }

   @SuppressWarnings("unchecked")
   protected String toString(Object value) {
      if (value instanceof String) {
         return (String) value;
      } else if (value instanceof Collection) {
         Collection<Object> list = (Collection<Object>) value;
         StringBuilder sb = new StringBuilder(32);
         boolean first = true;

         for (Object item : list) {
            if (first) {
               first = false;
            } else {
               sb.append(',');
            }

            if (item != null) {
               sb.append(item);
            }
         }

         return sb.toString();
      } else if (value.getClass().isArray()) {
         int len = Array.getLength(value);
         StringBuilder sb = new StringBuilder(32);
         boolean first = true;

         for (int i = 0; i < len; i++) {
            Object item = Array.get(value, i);

            if (first) {
               first = false;
            } else {
               sb.append(',');
            }

            if (item != null) {
               sb.append(item);
            }
         }
		
         return sb.toString();
      }
 
      return String.valueOf(value);
   }

   @Override
   public void visitClass(ClassModel _class) {
      startTag(ENTITY_CLASS, null, ATTR_PACKAGE, _class.getPackage(), ATTR_CLASS, _class.getClazz(), ATTR_GENERATED, _class.getGenerated(), ATTR_TEST, _class.getTest());

      if (_class.getCount() != null) {
         _class.getCount().accept(m_visitor);
      }

      endTag(ENTITY_CLASS);
   }

   @Override
   public void visitCount(CountModel count) {
      startTag(ENTITY_COUNT, true, null, ATTR_LINES, count.getLines(), ATTR_EMPTY, count.getEmpty(), ATTR_COMMENT, count.getComment(), ATTR_FILES, count.getFiles(), ATTR_GENERATED_FILES, count.getGeneratedFiles(), ATTR_TEST_FILES, count.getTestFiles());
   }

   @Override
   public void visitProject(ProjectModel project) {
      startTag(ENTITY_PROJECT, null, ATTR_NAME, project.getName());

      if (project.getCount() != null) {
         project.getCount().accept(m_visitor);
      }

      if (!project.getClasses().isEmpty()) {
         for (ClassModel class_ : project.getClasses().values()) {
            class_.accept(m_visitor);
         }
      }

      endTag(ENTITY_PROJECT);
   }

   @Override
   public void visitRoot(RootModel root) {
      startTag(ENTITY_ROOT, null);

      if (root.getCount() != null) {
         root.getCount().accept(m_visitor);
      }

      if (!root.getProjects().isEmpty()) {
         for (ProjectModel project : root.getProjects().values()) {
            project.accept(m_visitor);
         }
      }

      endTag(ENTITY_ROOT);
   }
}
