/* THIS FILE WAS AUTO GENERATED BY codegen-maven-plugin, DO NOT EDIT IT */
package org.unidal.maven.plugin.source.lines.transform;

import static org.unidal.maven.plugin.source.lines.Constants.ENTITY_CLASS;
import static org.unidal.maven.plugin.source.lines.Constants.ENTITY_COUNT;
import static org.unidal.maven.plugin.source.lines.Constants.ENTITY_PROJECT;
import static org.unidal.maven.plugin.source.lines.Constants.ENTITY_ROOT;

import java.io.IOException;
import java.util.Stack;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import org.unidal.maven.plugin.source.lines.IEntity;
import org.unidal.maven.plugin.source.lines.entity.ClassModel;
import org.unidal.maven.plugin.source.lines.entity.CountModel;
import org.unidal.maven.plugin.source.lines.entity.ProjectModel;
import org.unidal.maven.plugin.source.lines.entity.RootModel;

public class DefaultXmlParser extends DefaultHandler {

   private DefaultLinker m_linker = new DefaultLinker(true);

   private DefaultXmlMaker m_maker = new DefaultXmlMaker();

   private Stack<String> m_tags = new Stack<String>();

   private Stack<Object> m_objs = new Stack<Object>();

   private IEntity<?> m_root;

   private StringBuilder m_text = new StringBuilder(256);

   @SuppressWarnings("unchecked")
   public <T extends IEntity<?>> T parse(Class<T> entityType, InputSource input) throws IOException {
      try {
         SAXParserFactory factory = SAXParserFactory.newInstance();

         factory.setValidating(false);
         factory.setFeature("http://xml.org/sax/features/validation", false);
         factory.newSAXParser().parse(input, this);

         m_linker.finish();

         if (entityType.isAssignableFrom(m_root.getClass())) {
            return (T) m_root;
         } else {
            throw new IllegalArgumentException(String.format("Expected %s, but was %s", entityType, m_root.getClass()));
         }
      } catch (ParserConfigurationException e) {
         throw new IllegalStateException("Unable to get SAX Parser! " + e, e);
      } catch (SAXException e) {
         throw new IOException("Unable to parse XML! " + e, e);
      }
   }

   @SuppressWarnings("unchecked")
   protected <T> T convert(Class<T> type, String value, T defaultValue) {
      if (value == null || value.length() == 0) {
         return defaultValue;
      }

      if (type == Boolean.class) {
         return (T) Boolean.valueOf(value);
      } else if (type == Integer.class) {
         return (T) Integer.valueOf(value);
      } else if (type == Long.class) {
         return (T) Long.valueOf(value);
      } else if (type == Short.class) {
         return (T) Short.valueOf(value);
      } else if (type == Float.class) {
         return (T) Float.valueOf(value);
      } else if (type == Double.class) {
         return (T) Double.valueOf(value);
      } else if (type == Byte.class) {
         return (T) Byte.valueOf(value);
      } else if (type == Character.class) {
         return (T) (Character) value.charAt(0);
      } else {
         return (T) value;
      }
   }

   @Override
   public void characters(char[] ch, int start, int length) throws SAXException {
      m_text.append(ch, start, length);
   }

   @Override
   public void endElement(String uri, String localName, String qName) throws SAXException {
      if (uri == null || uri.length() == 0) {
         m_objs.pop();
         m_tags.pop();

      }

      m_text.setLength(0);
   }

   protected String getText() {
      return m_text.toString();
   }

   private void parseForClass(ClassModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      if (ENTITY_COUNT.equals(qName)) {
         CountModel count = m_maker.buildCount(attributes);

         m_linker.onCount(parentObj, count);
         m_objs.push(count);
      } else {
         throw new SAXException(String.format("Element(%s) is not expected under class!", qName));
      }

      m_tags.push(qName);
   }

   private void parseForCount(CountModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      m_objs.push(parentObj);
      m_tags.push(qName);
   }

   private void parseForProject(ProjectModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      if (ENTITY_COUNT.equals(qName)) {
         CountModel count = m_maker.buildCount(attributes);

         m_linker.onCount(parentObj, count);
         m_objs.push(count);
      } else if (ENTITY_CLASS.equals(qName)) {
         ClassModel class_ = m_maker.buildClass(attributes);

         m_linker.onClass(parentObj, class_);
         m_objs.push(class_);
      } else {
         throw new SAXException(String.format("Element(%s) is not expected under project!", qName));
      }

      m_tags.push(qName);
   }

   private void parseForRoot(RootModel parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
      if (ENTITY_COUNT.equals(qName)) {
         CountModel count = m_maker.buildCount(attributes);

         m_linker.onCount(parentObj, count);
         m_objs.push(count);
      } else if (ENTITY_PROJECT.equals(qName)) {
         ProjectModel project = m_maker.buildProject(attributes);

         m_linker.onProject(parentObj, project);
         m_objs.push(project);
      } else {
         throw new SAXException(String.format("Element(%s) is not expected under root!", qName));
      }

      m_tags.push(qName);
   }

   private void parseRoot(String qName, Attributes attributes) throws SAXException {
      if (ENTITY_ROOT.equals(qName)) {
         RootModel root = m_maker.buildRoot(attributes);

         m_root = root;
         m_objs.push(root);
         m_tags.push(qName);
      } else if (ENTITY_COUNT.equals(qName)) {
         CountModel count = m_maker.buildCount(attributes);

         m_root = count;
         m_objs.push(count);
         m_tags.push(qName);
      } else if (ENTITY_PROJECT.equals(qName)) {
         ProjectModel project = m_maker.buildProject(attributes);

         m_root = project;
         m_objs.push(project);
         m_tags.push(qName);
      } else if (ENTITY_CLASS.equals(qName)) {
         ClassModel _class = m_maker.buildClass(attributes);

         m_root = _class;
         m_objs.push(_class);
         m_tags.push(qName);
      } else {
         throw new SAXException("Unknown root element(" + qName + ") found!");
      }
   }

   @Override
   public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
      if (uri == null || uri.length() == 0) {
         if (m_objs.isEmpty()) { // root
            parseRoot(qName, attributes);
         } else {
            Object parent = m_objs.peek();
            String tag = m_tags.peek();

            if (parent instanceof RootModel) {
               parseForRoot((RootModel) parent, tag, qName, attributes);
            } else if (parent instanceof CountModel) {
               parseForCount((CountModel) parent, tag, qName, attributes);
            } else if (parent instanceof ProjectModel) {
               parseForProject((ProjectModel) parent, tag, qName, attributes);
            } else if (parent instanceof ClassModel) {
               parseForClass((ClassModel) parent, tag, qName, attributes);
            } else {
               throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
            }
         }

         m_text.setLength(0);
        } else {
         throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
      }
   }
}
