/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.source.lines;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import org.unidal.maven.plugin.source.lines.IEntity;
import org.unidal.maven.plugin.source.lines.entity.RootModel;
import org.unidal.maven.plugin.source.lines.transform.DefaultXmlBuilder;
import org.unidal.maven.plugin.source.lines.transform.DefaultXmlParser;
import org.xml.sax.InputSource;

public class RootModelHelper {
    public static String asXml(IEntity<?> entity) {
        return new DefaultXmlBuilder().build(entity);
    }

    public static <T extends IEntity<?>> T fromXml(Class<T> entityType, InputStream in) throws IOException {
        return new DefaultXmlParser().parse(entityType, new InputSource(RootModelHelper.withoutBom(in)));
    }

    public static <T extends IEntity<?>> T fromXml(Class<T> entityType, String xml) throws IOException {
        return new DefaultXmlParser().parse(entityType, new InputSource(new StringReader(xml)));
    }

    public static RootModel fromXml(InputStream in) throws IOException {
        return RootModelHelper.fromXml(RootModel.class, in);
    }

    public static RootModel fromXml(String xml) throws IOException {
        return RootModelHelper.fromXml(RootModel.class, xml);
    }

    private static InputStream withoutBom(InputStream in) throws IOException {
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        in.mark(3);
        if (in.read() != 239 || in.read() != 187 || in.read() != 191) {
            in.reset();
        }
        return in;
    }
}

