/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.source.lines.entity;

import org.unidal.maven.plugin.source.lines.BaseEntity;
import org.unidal.maven.plugin.source.lines.IVisitor;
import org.unidal.maven.plugin.source.lines.entity.CountModel;

public class ClassModel
extends BaseEntity<ClassModel> {
    private String m_package;
    private String m_class;
    private Boolean m_generated;
    private Boolean m_test;
    private CountModel m_count;

    public ClassModel() {
    }

    public ClassModel(String _package, String _class) {
        this.m_package = _package;
        this.m_class = _class;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitClass(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassModel) {
            ClassModel _o = (ClassModel)obj;
            if (!this.equals(this.getPackage(), _o.getPackage())) {
                return false;
            }
            return this.equals(this.getClazz(), _o.getClazz());
        }
        return false;
    }

    public String getClazz() {
        return this.m_class;
    }

    public CountModel getCount() {
        return this.m_count;
    }

    public Boolean getGenerated() {
        return this.m_generated;
    }

    public String getPackage() {
        return this.m_package;
    }

    public Boolean getTest() {
        return this.m_test;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_package == null ? 0 : this.m_package.hashCode());
        hash = hash * 31 + (this.m_class == null ? 0 : this.m_class.hashCode());
        return hash;
    }

    public boolean isGenerated() {
        return this.m_generated != null && this.m_generated != false;
    }

    public boolean isTest() {
        return this.m_test != null && this.m_test != false;
    }

    @Override
    public void mergeAttributes(ClassModel other) {
        this.assertAttributeEquals(other, "class", "package", this.m_package, other.getPackage());
        this.assertAttributeEquals(other, "class", "class", this.m_class, other.getClazz());
        if (other.getGenerated() != null) {
            this.m_generated = other.getGenerated();
        }
        if (other.getTest() != null) {
            this.m_test = other.getTest();
        }
    }

    public ClassModel setClazz(String _class) {
        this.m_class = _class;
        return this;
    }

    public ClassModel setCount(CountModel count) {
        this.m_count = count;
        return this;
    }

    public ClassModel setGenerated(Boolean generated) {
        this.m_generated = generated;
        return this;
    }

    public ClassModel setPackage(String _package) {
        this.m_package = _package;
        return this;
    }

    public ClassModel setTest(Boolean test) {
        this.m_test = test;
        return this;
    }
}

