/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.source.lines.entity;

import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.maven.plugin.source.lines.BaseEntity;
import org.unidal.maven.plugin.source.lines.IVisitor;
import org.unidal.maven.plugin.source.lines.entity.ClassModel;
import org.unidal.maven.plugin.source.lines.entity.CountModel;

public class ProjectModel
extends BaseEntity<ProjectModel> {
    private String m_name;
    private CountModel m_count;
    private Map<ClassModel, ClassModel> m_classes = new LinkedHashMap<ClassModel, ClassModel>();

    public ProjectModel() {
    }

    public ProjectModel(String name) {
        this.m_name = name;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitProject(this);
    }

    public ProjectModel addClass(ClassModel _class) {
        this.m_classes.put(_class, _class);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProjectModel) {
            ProjectModel _o = (ProjectModel)obj;
            return this.equals(this.getName(), _o.getName());
        }
        return false;
    }

    public ClassModel findClass(String _package, String _class) {
        return this.m_classes.get(new ClassModel(_package, _class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassModel findOrCreateClass(String _package, String _class) {
        ClassModel _key = new ClassModel(_package, _class);
        ClassModel class_ = this.m_classes.get(_key);
        if (class_ == null) {
            Map<ClassModel, ClassModel> map = this.m_classes;
            synchronized (map) {
                class_ = this.m_classes.get(_key);
                if (class_ == null) {
                    class_ = _key;
                    this.m_classes.put(_key, class_);
                }
            }
        }
        return class_;
    }

    public Map<ClassModel, ClassModel> getClasses() {
        return this.m_classes;
    }

    public CountModel getCount() {
        return this.m_count;
    }

    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_name == null ? 0 : this.m_name.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(ProjectModel other) {
        this.assertAttributeEquals(other, "project", "name", this.m_name, other.getName());
    }

    public ClassModel removeClass(String _package, String _class) {
        return this.m_classes.remove(new ClassModel(_package, _class));
    }

    public ProjectModel setCount(CountModel count) {
        this.m_count = count;
        return this;
    }

    public ProjectModel setName(String name) {
        this.m_name = name;
        return this;
    }
}

