/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.maven.plugin.source.lines.entity;

import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.maven.plugin.source.lines.BaseEntity;
import org.unidal.maven.plugin.source.lines.IVisitor;
import org.unidal.maven.plugin.source.lines.entity.CountModel;
import org.unidal.maven.plugin.source.lines.entity.ProjectModel;

public class RootModel
extends BaseEntity<RootModel> {
    private CountModel m_count;
    private Map<String, ProjectModel> m_projects = new LinkedHashMap<String, ProjectModel>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitRoot(this);
    }

    public RootModel addProject(ProjectModel project) {
        this.m_projects.put(project.getName(), project);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RootModel) {
            RootModel _o = (RootModel)obj;
            if (!this.equals(this.getCount(), _o.getCount())) {
                return false;
            }
            return this.equals(this.getProjects(), _o.getProjects());
        }
        return false;
    }

    public ProjectModel findProject(String name) {
        return this.m_projects.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectModel findOrCreateProject(String name) {
        ProjectModel project = this.m_projects.get(name);
        if (project == null) {
            Map<String, ProjectModel> map = this.m_projects;
            synchronized (map) {
                project = this.m_projects.get(name);
                if (project == null) {
                    project = new ProjectModel(name);
                    this.m_projects.put(name, project);
                }
            }
        }
        return project;
    }

    public CountModel getCount() {
        return this.m_count;
    }

    public Map<String, ProjectModel> getProjects() {
        return this.m_projects;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_count == null ? 0 : this.m_count.hashCode());
        hash = hash * 31 + (this.m_projects == null ? 0 : this.m_projects.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(RootModel other) {
    }

    public ProjectModel removeProject(String name) {
        return this.m_projects.remove(name);
    }

    public RootModel setCount(CountModel count) {
        this.m_count = count;
        return this;
    }
}

